/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import org.springframework.cloud.stream.binder.HeaderMode;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ConsumerProperties {
    private boolean autoStartup = true;
    private int concurrency = 1;
    private boolean partitioned;
    private int instanceCount = -1;
    private int instanceIndex = -1;
    private List<Integer> instanceIndexList;
    private int maxAttempts = 3;
    private int backOffInitialInterval = 1000;
    private int backOffMaxInterval = 10000;
    private double backOffMultiplier = 2.0;
    private boolean defaultRetryable = true;
    private String retryTemplateName;
    private Map<Class<? extends Throwable>, Boolean> retryableExceptions = new LinkedHashMap<Class<? extends Throwable>, Boolean>();
    private HeaderMode headerMode;
    private boolean useNativeDecoding;
    private boolean multiplex;
    private boolean batchMode;

    public String getRetryTemplateName() {
        return this.retryTemplateName;
    }

    public void setRetryTemplateName(String retryTemplateName) {
        this.retryTemplateName = retryTemplateName;
    }

    @Min(value=1L, message="Concurrency should be greater than zero.")
    public @Min(value=1L, message="Concurrency should be greater than zero.") int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    @Min(value=-1L, message="Instance count should be greater than or equal to -1.")
    public @Min(value=-1L, message="Instance count should be greater than or equal to -1.") int getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(int instanceCount) {
        this.instanceCount = instanceCount;
    }

    @Min(value=-1L, message="Instance index should be greater than or equal to -1")
    public @Min(value=-1L, message="Instance index should be greater than or equal to -1") int getInstanceIndex() {
        return this.instanceIndex;
    }

    public void setInstanceIndex(int instanceIndex) {
        this.instanceIndex = instanceIndex;
    }

    public List<Integer> getInstanceIndexList() {
        return this.instanceIndexList;
    }

    public void setInstanceIndexList(List<Integer> instanceIndexList) {
        this.instanceIndexList = instanceIndexList;
    }

    @Min(value=1L, message="Max attempts should be greater than zero.")
    public @Min(value=1L, message="Max attempts should be greater than zero.") int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @Min(value=1L, message="Backoff initial interval should be greater than zero.")
    public @Min(value=1L, message="Backoff initial interval should be greater than zero.") int getBackOffInitialInterval() {
        return this.backOffInitialInterval;
    }

    public void setBackOffInitialInterval(int backOffInitialInterval) {
        this.backOffInitialInterval = backOffInitialInterval;
    }

    @Min(value=1L, message="Backoff max interval should be greater than zero.")
    public @Min(value=1L, message="Backoff max interval should be greater than zero.") int getBackOffMaxInterval() {
        return this.backOffMaxInterval;
    }

    public void setBackOffMaxInterval(int backOffMaxInterval) {
        this.backOffMaxInterval = backOffMaxInterval;
    }

    @Min(value=1L, message="Backoff multiplier should be greater than zero.")
    public @Min(value=1L, message="Backoff multiplier should be greater than zero.") double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public boolean isDefaultRetryable() {
        return this.defaultRetryable;
    }

    public void setDefaultRetryable(boolean defaultRetryable) {
        this.defaultRetryable = defaultRetryable;
    }

    public Map<Class<? extends Throwable>, Boolean> getRetryableExceptions() {
        return this.retryableExceptions;
    }

    public void setRetryableExceptions(Map<Class<? extends Throwable>, Boolean> retryableExceptions) {
        this.retryableExceptions = retryableExceptions;
    }

    public HeaderMode getHeaderMode() {
        return this.headerMode;
    }

    public void setHeaderMode(HeaderMode headerMode) {
        this.headerMode = headerMode;
    }

    public boolean isUseNativeDecoding() {
        return this.useNativeDecoding;
    }

    public void setUseNativeDecoding(boolean useNativeDecoding) {
        this.useNativeDecoding = useNativeDecoding;
    }

    public boolean isMultiplex() {
        return this.multiplex;
    }

    public void setMultiplex(boolean multiplex) {
        this.multiplex = multiplex;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }
}

