/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.lang.reflect.Field;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.PartitionKeyExtractorStrategy;
import org.springframework.cloud.stream.binder.PartitionSelectorStrategy;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PartitionHandler {
    private final EvaluationContext evaluationContext;
    private final ProducerProperties producerProperties;
    private final PartitionKeyExtractorStrategy partitionKeyExtractorStrategy;
    private final PartitionSelectorStrategy partitionSelectorStrategy;
    private final ConfigurableListableBeanFactory beanFactory;
    private volatile int partitionCount;

    @Deprecated
    public PartitionHandler(EvaluationContext evaluationContext, ProducerProperties properties, PartitionKeyExtractorStrategy partitionKeyExtractorStrategy, PartitionSelectorStrategy partitionSelectorStrategy) {
        this(evaluationContext, properties, (ConfigurableListableBeanFactory)PartitionHandler.extractBeanFactoryFromEvaluationContext(evaluationContext));
    }

    public PartitionHandler(EvaluationContext evaluationContext, ProducerProperties properties, ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.evaluationContext = evaluationContext;
        this.producerProperties = properties;
        this.partitionKeyExtractorStrategy = this.getPartitionKeyExtractorStrategy(properties);
        this.partitionSelectorStrategy = this.getPartitionSelectorStrategy(properties);
        this.partitionCount = this.producerProperties.getPartitionCount();
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public int determinePartition(Message<?> message) {
        Object key = this.extractKey(message);
        int partition = this.producerProperties.getPartitionSelectorExpression() != null ? ((Integer)this.producerProperties.getPartitionSelectorExpression().getValue(this.evaluationContext, key, Integer.class)).intValue() : this.partitionSelectorStrategy.selectPartition(key, this.partitionCount);
        return Math.abs(partition % this.partitionCount);
    }

    private Object extractKey(Message<?> message) {
        Object key = this.invokeKeyExtractor(message);
        if (key == null && this.producerProperties.getPartitionKeyExpression() != null) {
            key = this.producerProperties.getPartitionKeyExpression().getValue(this.evaluationContext, message);
        }
        Assert.notNull((Object)key, (String)"Partition key cannot be null");
        return key;
    }

    private Object invokeKeyExtractor(Message<?> message) {
        if (this.partitionKeyExtractorStrategy != null) {
            return this.partitionKeyExtractorStrategy.extractKey(message);
        }
        return null;
    }

    private PartitionKeyExtractorStrategy getPartitionKeyExtractorStrategy(ProducerProperties producerProperties) {
        PartitionKeyExtractorStrategy partitionKeyExtractor;
        if (StringUtils.hasText((String)producerProperties.getPartitionKeyExtractorName())) {
            partitionKeyExtractor = (PartitionKeyExtractorStrategy)this.beanFactory.getBean(producerProperties.getPartitionKeyExtractorName(), PartitionKeyExtractorStrategy.class);
            Assert.notNull((Object)partitionKeyExtractor, (String)("PartitionKeyExtractorStrategy bean with the name '" + producerProperties.getPartitionKeyExtractorName() + "' can not be found. Has it been configured (e.g., @Bean)?"));
        } else {
            Map extractors = this.beanFactory.getBeansOfType(PartitionKeyExtractorStrategy.class);
            Assert.isTrue((extractors.size() <= 1 ? 1 : 0) != 0, (String)("Multiple  beans of type 'PartitionKeyExtractorStrategy' found. " + extractors + ". Please use 'spring.cloud.stream.bindings.output.producer.partitionKeyExtractorName' property to specify the name of the bean to be used."));
            partitionKeyExtractor = CollectionUtils.isEmpty((Map)extractors) ? null : (PartitionKeyExtractorStrategy)extractors.values().iterator().next();
        }
        return partitionKeyExtractor;
    }

    private PartitionSelectorStrategy getPartitionSelectorStrategy(ProducerProperties producerProperties) {
        PartitionSelectorStrategy partitionSelector;
        if (StringUtils.hasText((String)producerProperties.getPartitionSelectorName())) {
            partitionSelector = (PartitionSelectorStrategy)this.beanFactory.getBean(producerProperties.getPartitionSelectorName(), PartitionSelectorStrategy.class);
            Assert.notNull((Object)partitionSelector, (String)("PartitionSelectorStrategy bean with the name '" + producerProperties.getPartitionSelectorName() + "' can not be found. Has it been configured (e.g., @Bean)?"));
        } else {
            Map selectors = this.beanFactory.getBeansOfType(PartitionSelectorStrategy.class);
            Assert.isTrue((selectors.size() <= 1 ? 1 : 0) != 0, (String)("Multiple  beans of type 'PartitionSelectorStrategy' found. " + selectors + ". Please use 'spring.cloud.stream.bindings.output.producer.partitionSelectorName' property to specify the name of the bean to be used."));
            partitionSelector = CollectionUtils.isEmpty((Map)selectors) ? new DefaultPartitionSelector() : (PartitionSelectorStrategy)selectors.values().iterator().next();
        }
        return partitionSelector;
    }

    private static BeanFactory extractBeanFactoryFromEvaluationContext(EvaluationContext evaluationContext) {
        try {
            Field field = ReflectionUtils.findField(BeanFactoryResolver.class, (String)"beanFactory");
            field.setAccessible(true);
            return (BeanFactory)field.get(evaluationContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract beanFactory from EvaluationContext. Please use different constructor which allows you to pass the instance of the beanFactory.");
        }
    }

    private static class DefaultPartitionSelector
    implements PartitionSelectorStrategy {
        private DefaultPartitionSelector() {
        }

        @Override
        public int selectPartition(Object key, int partitionCount) {
            int hashCode = key.hashCode();
            if (hashCode == Integer.MIN_VALUE) {
                hashCode = 0;
            }
            return Math.abs(hashCode);
        }
    }
}

