/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.bind.validation.ValidationBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.validation.MessageInterpolatorFactory;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Validated
public abstract class AbstractExtendedBindingProperties<C, P, T extends BinderSpecificPropertiesProvider>
implements ExtendedBindingProperties<C, P>,
ApplicationContextAware {
    static Log logger = LogFactory.getLog(AbstractExtendedBindingProperties.class);
    private final Map<String, T> bindings = new HashMap<String, T>();
    private ConfigurableApplicationContext applicationContext = new GenericApplicationContext();
    private volatile Binder propertiesBinder;

    public void setBindings(Map<String, T> bindings) {
        this.bindings.putAll(bindings);
    }

    @Override
    public C getExtendedConsumerProperties(String binding) {
        this.bindIfNecessary(binding);
        return (C)((BinderSpecificPropertiesProvider)this.bindings.get(binding)).getConsumer();
    }

    @Override
    public P getExtendedProducerProperties(String binding) {
        this.bindIfNecessary(binding);
        return (P)((BinderSpecificPropertiesProvider)this.bindings.get(binding)).getProducer();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        GenericConversionService cs = (GenericConversionService)this.applicationContext.getBeanFactory().getConversionService();
        Iterable sources = ConfigurationPropertySources.get((Environment)this.applicationContext.getEnvironment());
        PropertySourcesPlaceholdersResolver placeholdersResolver = new PropertySourcesPlaceholdersResolver((Environment)this.applicationContext.getEnvironment());
        this.propertiesBinder = new Binder(sources, (PlaceholdersResolver)placeholdersResolver, (ConversionService)cs, null, null);
    }

    private void bindIfNecessary(String bindingName) {
        if (!this.bindings.containsKey(bindingName)) {
            this.bindToDefault(bindingName);
        }
    }

    private void bindToDefault(String binding) {
        BinderSpecificPropertiesProvider extendedBindingPropertiesTarget = (BinderSpecificPropertiesProvider)BeanUtils.instantiateClass(this.getExtendedPropertiesEntryClass());
        if (Jsr303Validator.isJsr303Present((ApplicationContext)this.applicationContext)) {
            Jsr303Validator validator = new Jsr303Validator((ApplicationContext)this.applicationContext);
            this.propertiesBinder.bind(this.getDefaultsPrefix(), Bindable.ofInstance((Object)extendedBindingPropertiesTarget), (BindHandler)new ValidationBindHandler(new Validator[]{validator}));
        } else {
            this.propertiesBinder.bind(this.getDefaultsPrefix(), Bindable.ofInstance((Object)extendedBindingPropertiesTarget));
        }
        this.bindings.put(binding, extendedBindingPropertiesTarget);
    }

    protected Map<String, T> doGetBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    private class Jsr303Validator
    implements Validator {
        private static final String[] VALIDATOR_CLASSES = new String[]{"jakarta.validation.Validator", "jakarta.validation.ValidatorFactory", "jakarta.validation.bootstrap.GenericBootstrap"};
        private final Delegate delegate;

        Jsr303Validator(ApplicationContext applicationContext) {
            this.delegate = new Delegate(applicationContext);
        }

        public boolean supports(Class<?> type) {
            return this.delegate.supports(type);
        }

        public void validate(Object target, Errors errors) {
            this.delegate.validate(target, errors);
        }

        static boolean isJsr303Present(ApplicationContext applicationContext) {
            ClassLoader classLoader = applicationContext.getClassLoader();
            for (String validatorClass : VALIDATOR_CLASSES) {
                if (ClassUtils.isPresent((String)validatorClass, (ClassLoader)classLoader)) continue;
                return false;
            }
            return true;
        }

        private static class Delegate
        extends LocalValidatorFactoryBean {
            Delegate(ApplicationContext applicationContext) {
                this.setApplicationContext(applicationContext);
                this.setMessageInterpolator(new MessageInterpolatorFactory((MessageSource)applicationContext).getObject());
                try {
                    this.afterPropertiesSet();
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to execute afterPropertiesSet() on aplication context", (Throwable)e);
                }
            }
        }
    }
}

