/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.configuration;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.task.batch.listener.TaskBatchExecutionListener;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class TaskBatchExecutionListenerBeanPostProcessor
implements BeanPostProcessor {
    @Autowired
    private ApplicationContext applicationContext;
    private List<String> jobNames = new ArrayList<String>();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.jobNames.size() > 0 && !this.jobNames.contains(beanName)) {
            return bean;
        }
        int length = this.applicationContext.getBeanNamesForType(TaskBatchExecutionListener.class).length;
        if (bean instanceof AbstractJob) {
            if (length != 1) {
                throw new IllegalStateException("The application context is required to have exactly 1 instance of the TaskBatchExecutionListener but has " + length);
            }
            ((AbstractJob)bean).registerJobExecutionListener((JobExecutionListener)this.applicationContext.getBean(TaskBatchExecutionListener.class));
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setJobNames(List<String> jobNames) {
        Assert.notNull(jobNames, (String)"A list is required");
        this.jobNames = jobNames;
    }
}

