/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.configuration;

import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.task.batch.configuration.TaskBatchProperties;
import org.springframework.cloud.task.batch.handler.TaskJobLauncherCommandLineRunner;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TaskJobLauncherCommandLineRunnerFactoryBean
implements FactoryBean<TaskJobLauncherCommandLineRunner> {
    private JobLauncher jobLauncher;
    private JobExplorer jobExplorer;
    private List<Job> jobs;
    private String jobNames;
    private JobRegistry jobRegistry;
    private Integer order = 0;
    private TaskBatchProperties taskBatchProperties;
    private JobRepository jobRepository;

    public TaskJobLauncherCommandLineRunnerFactoryBean(JobLauncher jobLauncher, JobExplorer jobExplorer, List<Job> jobs, TaskBatchProperties taskBatchProperties, JobRegistry jobRegistry, JobRepository jobRepository) {
        Assert.notNull((Object)taskBatchProperties, (String)"properties must not be null");
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        Assert.notEmpty(jobs, (String)"jobs must not be null nor empty");
        this.jobs = jobs;
        this.jobNames = taskBatchProperties.getJobNames();
        this.jobRegistry = jobRegistry;
        this.taskBatchProperties = taskBatchProperties;
        this.order = taskBatchProperties.getCommandLineRunnerOrder();
        this.jobRepository = jobRepository;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public TaskJobLauncherCommandLineRunner getObject() {
        TaskJobLauncherCommandLineRunner taskJobLauncherCommandLineRunner = new TaskJobLauncherCommandLineRunner(this.jobLauncher, this.jobExplorer, this.jobRepository, this.taskBatchProperties);
        taskJobLauncherCommandLineRunner.setJobs(this.jobs);
        if (StringUtils.hasText((String)this.jobNames)) {
            taskJobLauncherCommandLineRunner.setJobNames(this.jobNames);
        }
        taskJobLauncherCommandLineRunner.setJobRegistry(this.jobRegistry);
        if (this.order != null) {
            taskJobLauncherCommandLineRunner.setOrder(this.order);
        }
        return taskJobLauncherCommandLineRunner;
    }

    public Class<?> getObjectType() {
        return TaskJobLauncherCommandLineRunner.class;
    }
}

