/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.cloud.task.batch.listener.support.StepExecutionEvent;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class EventEmittingStepExecutionListener
implements StepExecutionListener {
    private MessagePublisher<StepExecutionEvent> messagePublisher;

    public EventEmittingStepExecutionListener(MessageChannel output) {
        Assert.notNull((Object)output, (String)"An output channel is required");
        this.messagePublisher = new MessagePublisher(output);
    }

    public void beforeStep(StepExecution stepExecution) {
        this.messagePublisher.publish(new StepExecutionEvent(stepExecution));
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        this.messagePublisher.publish(new StepExecutionEvent(stepExecution));
        return stepExecution.getExitStatus();
    }
}

