/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class MessagePublisher<P> {
    private final MessageChannel listenerEventsChannel;

    public MessagePublisher(MessageChannel listenerEventsChannel) {
        Assert.notNull((Object)listenerEventsChannel, (String)"listenerEventsChannel must not be null");
        this.listenerEventsChannel = listenerEventsChannel;
    }

    public final void publish(P payload) {
        if (payload instanceof Message) {
            this.publishMessage((Message)payload);
        } else {
            Message message = MessageBuilder.withPayload(payload).build();
            this.listenerEventsChannel.send(message);
        }
    }

    private final void publishMessage(Message<?> message) {
        this.listenerEventsChannel.send(message);
    }

    public void publishWithThrowableHeader(P payload, String header) {
        Message message = MessageBuilder.withPayload(payload).setHeader("batch_exception", (Object)header).build();
        this.publishMessage(message);
    }
}

