/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.task.batch.listener.EventEmittingChunkListener;
import org.springframework.cloud.task.batch.listener.EventEmittingItemProcessListener;
import org.springframework.cloud.task.batch.listener.EventEmittingItemReadListener;
import org.springframework.cloud.task.batch.listener.EventEmittingItemWriteListener;
import org.springframework.cloud.task.batch.listener.EventEmittingJobExecutionListener;
import org.springframework.cloud.task.batch.listener.EventEmittingSkipListener;
import org.springframework.cloud.task.batch.listener.EventEmittingStepExecutionListener;
import org.springframework.cloud.task.batch.listener.support.TaskBatchEventListenerBeanPostProcessor;
import org.springframework.cloud.task.batch.listener.support.TaskEventProperties;
import org.springframework.cloud.task.listener.TaskLifecycleListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.messaging.MessageChannel;

@Configuration
@ConditionalOnClass(value={Job.class})
@ConditionalOnBean(value={Job.class, TaskLifecycleListener.class})
@ConditionalOnProperty(prefix="spring.cloud.task.batch.events", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class BatchEventAutoConfiguration {
    public static final String JOB_EXECUTION_EVENTS_LISTENER = "jobExecutionEventsListener";
    public static final String CHUNK_EVENTS_LISTENER = "chunkEventsListener";
    public static final String STEP_EXECUTION_EVENTS_LISTENER = "stepExecutionEventsListener";
    public static final String ITEM_READ_EVENTS_LISTENER = "itemReadEventsListener";
    public static final String ITEM_WRITE_EVENTS_LISTENER = "itemWriteEventsListener";
    public static final String ITEM_PROCESS_EVENTS_LISTENER = "itemProcessEventsListener";
    public static final String SKIP_EVENTS_LISTENER = "skipEventsListener";

    @Bean
    @ConditionalOnMissingBean
    public TaskBatchEventListenerBeanPostProcessor batchTaskEventListenerBeanPostProcessor() {
        return new TaskBatchEventListenerBeanPostProcessor();
    }

    public static interface BatchEventsChannels {
        public static final String JOB_EXECUTION_EVENTS = "job-execution-events";
        public static final String STEP_EXECUTION_EVENTS = "step-execution-events";
        public static final String CHUNK_EXECUTION_EVENTS = "chunk-events";
        public static final String ITEM_READ_EVENTS = "item-read-events";
        public static final String ITEM_PROCESS_EVENTS = "item-process-events";
        public static final String ITEM_WRITE_EVENTS = "item-write-events";
        public static final String SKIP_EVENTS = "skip-events";

        @Output(value="job-execution-events")
        public MessageChannel jobExecutionEvents();

        @Output(value="step-execution-events")
        public MessageChannel stepExecutionEvents();

        @Output(value="chunk-events")
        public MessageChannel chunkEvents();

        @Output(value="item-read-events")
        public MessageChannel itemReadEvents();

        @Output(value="item-write-events")
        public MessageChannel itemWriteEvents();

        @Output(value="item-process-events")
        public MessageChannel itemProcessEvents();

        @Output(value="skip-events")
        public MessageChannel skipEvents();
    }

    @Configuration
    @ConditionalOnClass(value={EnableBinding.class})
    @EnableBinding(value={BatchEventsChannels.class})
    @EnableConfigurationProperties(value={TaskEventProperties.class})
    @ConditionalOnMissingBean(name={"jobExecutionEventsListener"})
    public static class JobExecutionListenerConfiguration {
        @Autowired
        private BatchEventsChannels listenerChannels;
        @Autowired
        private TaskEventProperties taskEventProperties;

        @Bean
        @Lazy
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public JobExecutionListener jobExecutionEventsListener() {
            return new EventEmittingJobExecutionListener(this.listenerChannels.jobExecutionEvents(), this.taskEventProperties.getJobExecutionOrder());
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.step-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public StepExecutionListener stepExecutionEventsListener() {
            return new EventEmittingStepExecutionListener(this.listenerChannels.stepExecutionEvents(), this.taskEventProperties.getStepExecutionOrder());
        }

        @Bean
        @Lazy
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.chunk", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public EventEmittingChunkListener chunkEventsListener() {
            return new EventEmittingChunkListener(this.listenerChannels.chunkEvents(), this.taskEventProperties.getChunkOrder());
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.item-read", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public ItemReadListener itemReadEventsListener() {
            return new EventEmittingItemReadListener(this.listenerChannels.itemReadEvents(), this.taskEventProperties.getItemReadOrder());
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.item-write", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public ItemWriteListener itemWriteEventsListener() {
            return new EventEmittingItemWriteListener(this.listenerChannels.itemWriteEvents(), this.taskEventProperties.getItemWriteOrder());
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.item-process", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public ItemProcessListener itemProcessEventsListener() {
            return new EventEmittingItemProcessListener(this.listenerChannels.itemProcessEvents(), this.taskEventProperties.getItemProcessOrder());
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.cloud.task.batch.events.skip", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public SkipListener skipEventsListener() {
            return new EventEmittingSkipListener(this.listenerChannels.skipEvents(), this.taskEventProperties.getItemProcessOrder());
        }
    }
}

