/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import java.util.Date;
import org.springframework.batch.core.JobParameter;

public class JobParameterEvent {
    private Object parameter;
    private ParameterType parameterType;
    private boolean identifying;

    public JobParameterEvent() {
    }

    public JobParameterEvent(JobParameter jobParameter) {
        this.parameter = jobParameter.getValue();
        this.parameterType = ParameterType.convert(jobParameter.getType());
        this.identifying = jobParameter.isIdentifying();
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public Object getValue() {
        if (this.parameter != null && this.parameter.getClass().isInstance(Date.class)) {
            return new Date(((Date)this.parameter).getTime());
        }
        return this.parameter;
    }

    public ParameterType getType() {
        return this.parameterType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParameterEvent)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JobParameterEvent rhs = (JobParameterEvent)obj;
        return this.parameter == null ? rhs.parameter == null && this.parameterType == rhs.parameterType : this.parameter.equals(rhs.parameter);
    }

    public String toString() {
        return this.parameter == null ? null : (this.parameterType == ParameterType.DATE ? "" + ((Date)this.parameter).getTime() : this.parameter.toString());
    }

    public int hashCode() {
        return 7 + 21 * (this.parameter == null ? this.parameterType.hashCode() : this.parameter.hashCode());
    }

    public static enum ParameterType {
        STRING,
        DATE,
        LONG,
        DOUBLE;


        public static ParameterType convert(JobParameter.ParameterType type) {
            if (JobParameter.ParameterType.DATE.equals((Object)type)) {
                return DATE;
            }
            if (JobParameter.ParameterType.DOUBLE.equals((Object)type)) {
                return DOUBLE;
            }
            if (JobParameter.ParameterType.LONG.equals((Object)type)) {
                return LONG;
            }
            if (JobParameter.ParameterType.STRING.equals((Object)type)) {
                return STRING;
            }
            throw new IllegalArgumentException("Unable to convert type");
        }
    }
}

