/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener;

import org.springframework.batch.core.ItemProcessListener;
import org.springframework.cloud.task.batch.listener.support.MessagePublisher;
import org.springframework.core.Ordered;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class EventEmittingItemProcessListener
implements ItemProcessListener,
Ordered {
    private MessagePublisher<String> messagePublisher;
    private int order = Integer.MAX_VALUE;

    public EventEmittingItemProcessListener(MessageChannel output) {
        Assert.notNull((Object)output, (String)"An output channel is required");
        this.messagePublisher = new MessagePublisher(output);
    }

    public EventEmittingItemProcessListener(MessageChannel output, int order) {
        this(output);
        this.order = order;
    }

    public void beforeProcess(Object item) {
    }

    public void afterProcess(Object item, Object result) {
        if (result == null) {
            this.messagePublisher.publish("1 item was filtered");
        } else if (item.equals(result)) {
            this.messagePublisher.publish("item equaled result after processing");
        } else {
            this.messagePublisher.publish("item did not equal result after processing");
        }
    }

    public void onProcessError(Object item, Exception e) {
        this.messagePublisher.publishWithThrowableHeader("Exception while item was being processed", e.getMessage());
    }

    public int getOrder() {
        return this.order;
    }
}

