/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.batch.listener.support;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.cloud.task.batch.listener.support.ExitStatus;
import org.springframework.cloud.task.batch.listener.support.JobInstanceEvent;
import org.springframework.cloud.task.batch.listener.support.JobParametersEvent;
import org.springframework.cloud.task.batch.listener.support.StepExecutionEvent;

public class JobExecutionEvent
extends Entity {
    private JobParametersEvent jobParameters;
    private JobInstanceEvent jobInstance;
    private Collection<StepExecutionEvent> stepExecutions = new CopyOnWriteArraySet<StepExecutionEvent>();
    private BatchStatus status = BatchStatus.STARTING;
    private LocalDateTime startTime = null;
    private LocalDateTime createTime = LocalDateTime.now();
    private LocalDateTime endTime = null;
    private LocalDateTime lastUpdated = null;
    private ExitStatus exitStatus = new ExitStatus(new org.springframework.batch.core.ExitStatus("UNKNOWN"));
    private ExecutionContext executionContext = new ExecutionContext();
    private List<Throwable> failureExceptions = new CopyOnWriteArrayList<Throwable>();

    public JobExecutionEvent() {
    }

    public JobExecutionEvent(JobExecution original) {
        this.jobParameters = new JobParametersEvent(original.getJobParameters().getParameters());
        this.jobInstance = new JobInstanceEvent(original.getJobInstance().getId(), original.getJobInstance().getJobName());
        for (StepExecution stepExecution : original.getStepExecutions()) {
            this.stepExecutions.add(new StepExecutionEvent(stepExecution));
        }
        this.status = original.getStatus();
        this.startTime = original.getStartTime();
        this.createTime = original.getCreateTime();
        this.endTime = original.getEndTime();
        this.lastUpdated = original.getLastUpdated();
        this.exitStatus = new ExitStatus(original.getExitStatus());
        this.executionContext = original.getExecutionContext();
        this.failureExceptions = original.getFailureExceptions();
        this.setId(original.getId());
        this.setVersion(original.getVersion());
    }

    public JobParametersEvent getJobParameters() {
        return this.jobParameters;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchStatus status) {
        this.status = status;
    }

    public void upgradeStatus(BatchStatus status) {
        this.status = this.status.upgradeTo(status);
    }

    public Long getJobId() {
        if (this.jobInstance != null) {
            return this.jobInstance.getId();
        }
        return null;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public JobInstanceEvent getJobInstance() {
        return this.jobInstance;
    }

    public void setJobInstance(JobInstanceEvent jobInstance) {
        this.jobInstance = jobInstance;
    }

    public Collection<StepExecutionEvent> getStepExecutions() {
        return Collections.unmodifiableList(new ArrayList<StepExecutionEvent>(this.stepExecutions));
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(LocalDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public List<Throwable> getFailureExceptions() {
        return this.failureExceptions;
    }

    public synchronized void addFailureException(Throwable t) {
        this.failureExceptions.add(t);
    }

    public synchronized List<Throwable> getAllFailureExceptions() {
        HashSet<Throwable> allExceptions = new HashSet<Throwable>(this.failureExceptions);
        for (StepExecutionEvent stepExecution : this.stepExecutions) {
            allExceptions.addAll(stepExecution.getFailureExceptions());
        }
        return new ArrayList<Throwable>(allExceptions);
    }

    public String toString() {
        return super.toString() + String.format(", startTime=%s, endTime=%s, lastUpdated=%s, status=%s, exitStatus=%s, job=[%s], jobParameters=[%s]", new Object[]{this.startTime, this.endTime, this.lastUpdated, this.status, this.exitStatus, this.jobInstance, this.jobParameters});
    }
}

