/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config.consul;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.PropertyNameTransformer;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.cloud.vault.config.consul.VaultConsulProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.vault.core.util.PropertyTransformer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={VaultConsulProperties.class})
public class VaultConfigConsulBootstrapConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConsulSecretBackendMetadataFactory consulSecretBackendAccessorFactory() {
        return new ConsulSecretBackendMetadataFactory();
    }

    public static class ConsulSecretBackendMetadataFactory
    implements SecretBackendMetadataFactory<VaultConsulProperties> {
        static SecretBackendMetadata forConsul(final VaultConsulProperties properties) {
            Assert.notNull((Object)properties, (String)"VaultConsulProperties must not be null");
            final PropertyNameTransformer transformer = new PropertyNameTransformer();
            transformer.addKeyTransformation("token", properties.getTokenProperty());
            return new SecretBackendMetadata(){

                public String getName() {
                    return String.format("%s with Role %s", properties.getBackend(), properties.getRole());
                }

                public String getPath() {
                    return String.format("%s/creds/%s", properties.getBackend(), properties.getRole());
                }

                public Map<String, String> getVariables() {
                    HashMap<String, String> variables = new HashMap<String, String>();
                    variables.put("backend", properties.getBackend());
                    variables.put("key", String.format("creds/%s", properties.getRole()));
                    return variables;
                }

                public PropertyTransformer getPropertyTransformer() {
                    return transformer;
                }
            };
        }

        public SecretBackendMetadata createMetadata(VaultConsulProperties backendDescriptor) {
            return ConsulSecretBackendMetadataFactory.forConsul(backendDescriptor);
        }

        public boolean supports(VaultSecretBackendDescriptor backendDescriptor) {
            return backendDescriptor instanceof VaultConsulProperties;
        }
    }
}

