/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.cloud.vault.config.KubernetesJwtSupplier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.vault.VaultException;

class KubernetesServiceAccountTokenFile
implements KubernetesJwtSupplier {
    static final String DEFAULT_KUBERNETES_SERVICE_ACCOUNT_TOKEN_FILE = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private byte[] token;

    KubernetesServiceAccountTokenFile() {
        this(DEFAULT_KUBERNETES_SERVICE_ACCOUNT_TOKEN_FILE);
    }

    KubernetesServiceAccountTokenFile(String path) {
        this((Resource)new FileSystemResource(path));
    }

    KubernetesServiceAccountTokenFile(Resource resource) {
        Assert.isTrue((boolean)resource.exists(), (String)String.format("Resource %s does not exist", resource));
        try {
            this.token = KubernetesServiceAccountTokenFile.readToken(resource);
        }
        catch (IOException e) {
            throw new VaultException(String.format("Kube JWT token retrieval from %s failed", resource), (Throwable)e);
        }
    }

    @Override
    public String get() {
        return new String(this.token, StandardCharsets.US_ASCII);
    }

    private static byte[] readToken(Resource resource) throws IOException {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        try (InputStream is = resource.getInputStream();){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
    }
}

