/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.vault.config.PropertyTransformerSupport;
import org.springframework.util.Assert;
import org.springframework.vault.core.util.PropertyTransformer;

public class PropertyNameTransformer
extends PropertyTransformerSupport
implements PropertyTransformer {
    private final Map<String, String> nameMapping = new HashMap<String, String>();

    public void addKeyTransformation(String sourceKeyName, String targetKeyName) {
        Assert.hasText((String)sourceKeyName, (String)"Source key name must not be empty");
        Assert.hasText((String)targetKeyName, (String)"Target key name must not be empty");
        this.nameMapping.put(sourceKeyName, targetKeyName);
    }

    public Map<String, String> transformProperties(Map<String, String> input) {
        if (input == null) {
            return null;
        }
        LinkedHashMap<String, String> transformed = new LinkedHashMap<String, String>(input.size(), 1.0f);
        for (String key : input.keySet()) {
            String value = input.get(key);
            String translatedKey = key;
            if (this.nameMapping.containsKey(key)) {
                translatedKey = this.nameMapping.get(key);
            }
            transformed.put(translatedKey, value);
        }
        return transformed;
    }
}

