/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.vault.config.DefaultSecretBackendConfigurer;
import org.springframework.cloud.vault.config.GenericSecretBackendMetadata;
import org.springframework.cloud.vault.config.LeasingVaultPropertySourceLocator;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfiguration;
import org.springframework.cloud.vault.config.SecretBackendFactories;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultBootstrapConfiguration;
import org.springframework.cloud.vault.config.VaultConfigTemplate;
import org.springframework.cloud.vault.config.VaultConfigurer;
import org.springframework.cloud.vault.config.VaultGenericBackendProperties;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultPropertySourceLocator;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.lease.SecretLeaseContainer;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VaultGenericBackendProperties.class})
@Order(value=0x7FFFFFF5)
public class VaultBootstrapPropertySourceConfiguration
implements InitializingBean {
    private final ConfigurableApplicationContext applicationContext;
    private Collection<VaultSecretBackendDescriptor> vaultSecretBackendDescriptors;
    private Collection<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> factories;

    public VaultBootstrapPropertySourceConfiguration(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.vaultSecretBackendDescriptors = this.applicationContext.getBeansOfType(VaultSecretBackendDescriptor.class).values();
        this.factories = this.applicationContext.getBeansOfType(SecretBackendMetadataFactory.class).values();
    }

    @Bean
    public PropertySourceLocator vaultPropertySourceLocator(VaultOperations operations, VaultProperties vaultProperties, VaultGenericBackendProperties vaultGenericBackendProperties, ObjectFactory<SecretLeaseContainer> secretLeaseContainerObjectFactory) {
        VaultConfigTemplate vaultConfigTemplate = new VaultConfigTemplate(operations, vaultProperties);
        PropertySourceLocatorConfiguration propertySourceLocatorConfiguration = this.getPropertySourceConfiguration(vaultGenericBackendProperties);
        if (vaultProperties.getConfig().getLifecycle().isEnabled()) {
            this.applicationContext.registerShutdownHook();
            SecretLeaseContainer secretLeaseContainer = (SecretLeaseContainer)secretLeaseContainerObjectFactory.getObject();
            secretLeaseContainer.start();
            return new LeasingVaultPropertySourceLocator(vaultProperties, propertySourceLocatorConfiguration, secretLeaseContainer);
        }
        return new VaultPropertySourceLocator(vaultConfigTemplate, vaultProperties, propertySourceLocatorConfiguration);
    }

    private PropertySourceLocatorConfiguration getPropertySourceConfiguration(VaultGenericBackendProperties vaultGenericBackendProperties) {
        Collection<SecretBackendMetadata> backendAccessors;
        Collection configurers = this.applicationContext.getBeansOfType(VaultConfigurer.class).values();
        DefaultSecretBackendConfigurer secretBackendConfigurer = new DefaultSecretBackendConfigurer();
        if (configurers.isEmpty()) {
            secretBackendConfigurer.registerDefaultGenericSecretBackends(true).registerDefaultDiscoveredSecretBackends(true);
        } else {
            for (VaultConfigurer vaultConfigurer : configurers) {
                vaultConfigurer.addSecretBackends(secretBackendConfigurer);
            }
        }
        if (secretBackendConfigurer.isRegisterDefaultGenericSecretBackends()) {
            if (vaultGenericBackendProperties.isEnabled()) {
                List<String> contexts = GenericSecretBackendMetadata.buildContexts(vaultGenericBackendProperties, Arrays.asList(this.applicationContext.getEnvironment().getActiveProfiles()));
                for (String context : contexts) {
                    secretBackendConfigurer.add(GenericSecretBackendMetadata.create(vaultGenericBackendProperties.getBackend(), context));
                }
            }
            backendAccessors = SecretBackendFactories.createSecretBackendMetadata(this.vaultSecretBackendDescriptors, this.factories);
            for (SecretBackendMetadata metadata : backendAccessors) {
                secretBackendConfigurer.add(metadata);
            }
        }
        if (secretBackendConfigurer.isRegisterDefaultDiscoveredSecretBackends()) {
            backendAccessors = SecretBackendFactories.createSecretBackendMetadata(this.vaultSecretBackendDescriptors, this.factories);
            for (SecretBackendMetadata metadata : backendAccessors) {
                secretBackendConfigurer.add(metadata);
            }
        }
        return secretBackendConfigurer;
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public SecretLeaseContainer secretLeaseContainer(VaultOperations vaultOperations, VaultBootstrapConfiguration.TaskSchedulerWrapper taskSchedulerWrapper) {
        return new SecretLeaseContainer(vaultOperations, (TaskScheduler)taskSchedulerWrapper.getTaskScheduler());
    }
}

