/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.support.VaultHealth;

public class VaultHealthIndicator
implements HealthIndicator {
    private final VaultOperations vaultOperations;

    public VaultHealthIndicator(VaultOperations vaultOperations) {
        this.vaultOperations = vaultOperations;
    }

    public Health health() {
        try {
            VaultHealth vaultHealthResponse = this.vaultOperations.opsForSys().health();
            if (!vaultHealthResponse.isInitialized()) {
                return Health.down().withDetail("state", (Object)"Vault uninitialized").build();
            }
            if (vaultHealthResponse.isSealed()) {
                return Health.down().withDetail("state", (Object)"Vault sealed").build();
            }
            if (vaultHealthResponse.isStandby()) {
                return Health.up().withDetail("state", (Object)"Vault in standby").build();
            }
            return Health.up().build();
        }
        catch (Exception e) {
            return Health.down((Exception)e).build();
        }
    }
}

