/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.net.URI;
import java.time.Duration;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.VaultBootstrapConfiguration;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.AuthenticationStepsOperator;
import org.springframework.vault.authentication.CachingVaultTokenSupplier;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.ReactiveLifecycleAwareSessionManager;
import org.springframework.vault.authentication.ReactiveSessionManager;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.authentication.VaultTokenSupplier;
import org.springframework.vault.client.ReactiveVaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.config.ClientHttpConnectorFactory;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.ReactiveVaultTemplate;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@ConditionalOnExpression(value="${spring.cloud.vault.reactive.enabled:true}")
@ConditionalOnClass(value={Flux.class, WebClient.class, ReactiveVaultOperations.class})
@EnableConfigurationProperties(value={VaultProperties.class})
@Order(value=0x7FFFFFF5)
public class VaultReactiveBootstrapConfiguration {
    private final VaultProperties vaultProperties;
    private final VaultEndpoint vaultEndpoint;
    private final ClientHttpConnector clientHttpConnector;

    public VaultReactiveBootstrapConfiguration(VaultProperties vaultProperties) {
        this.vaultProperties = vaultProperties;
        this.vaultEndpoint = VaultReactiveBootstrapConfiguration.getVaultEndpoint(vaultProperties);
        this.clientHttpConnector = VaultReactiveBootstrapConfiguration.createConnector(this.vaultProperties);
    }

    private static VaultEndpoint getVaultEndpoint(VaultProperties vaultProperties) {
        if (StringUtils.hasText((String)vaultProperties.getUri())) {
            return VaultEndpoint.from((URI)URI.create(vaultProperties.getUri()));
        }
        VaultEndpoint vaultEndpoint = new VaultEndpoint();
        vaultEndpoint.setHost(vaultProperties.getHost());
        vaultEndpoint.setPort(vaultProperties.getPort());
        vaultEndpoint.setScheme(vaultProperties.getScheme());
        return vaultEndpoint;
    }

    private static ClientHttpConnector createConnector(VaultProperties vaultProperties) {
        SslConfiguration sslConfiguration;
        ClientOptions clientOptions = new ClientOptions(Duration.ofMillis(vaultProperties.getConnectionTimeout()), Duration.ofMillis(vaultProperties.getReadTimeout()));
        VaultProperties.Ssl ssl = vaultProperties.getSsl();
        if (ssl != null) {
            SslConfiguration.KeyStoreConfiguration keyStore = SslConfiguration.KeyStoreConfiguration.unconfigured();
            SslConfiguration.KeyStoreConfiguration trustStore = SslConfiguration.KeyStoreConfiguration.unconfigured();
            if (ssl.getKeyStore() != null) {
                keyStore = StringUtils.hasText((String)ssl.getKeyStorePassword()) ? SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getKeyStore(), (char[])ssl.getKeyStorePassword().toCharArray()) : SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getKeyStore());
            }
            if (ssl.getTrustStore() != null) {
                trustStore = StringUtils.hasText((String)ssl.getTrustStorePassword()) ? SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getTrustStore(), (char[])ssl.getTrustStorePassword().toCharArray()) : SslConfiguration.KeyStoreConfiguration.of((Resource)ssl.getTrustStore());
            }
            sslConfiguration = new SslConfiguration(keyStore, trustStore);
        } else {
            sslConfiguration = SslConfiguration.unconfigured();
        }
        return ClientHttpConnectorFactory.create((ClientOptions)clientOptions, (SslConfiguration)sslConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveVaultOperations.class})
    public ReactiveVaultTemplate reactiveVaultTemplate(ReactiveSessionManager tokenSupplier) {
        return new ReactiveVaultTemplate(this.vaultEndpoint, this.clientHttpConnector, (VaultTokenSupplier)tokenSupplier);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveSessionManager reactiveVaultSessionManager(BeanFactory beanFactory, ObjectFactory<VaultBootstrapConfiguration.TaskSchedulerWrapper> asyncTaskExecutorFactory) {
        VaultTokenSupplier vaultTokenSupplier = (VaultTokenSupplier)beanFactory.getBean("vaultTokenSupplier", VaultTokenSupplier.class);
        if (this.vaultProperties.getConfig().getLifecycle().isEnabled()) {
            WebClient webClient = ReactiveVaultClients.createWebClient((VaultEndpoint)this.vaultEndpoint, (ClientHttpConnector)this.clientHttpConnector);
            return new ReactiveLifecycleAwareSessionManager(vaultTokenSupplier, (TaskScheduler)((VaultBootstrapConfiguration.TaskSchedulerWrapper)asyncTaskExecutorFactory.getObject()).getTaskScheduler(), webClient);
        }
        return CachingVaultTokenSupplier.of((VaultTokenSupplier)vaultTokenSupplier);
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionManager vaultSessionManager(ReactiveSessionManager sessionManager) {
        return () -> ((Mono)sessionManager.getSessionToken()).block();
    }

    @Bean
    @ConditionalOnMissingBean(name={"vaultTokenSupplier"})
    public VaultTokenSupplier vaultTokenSupplier(ListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        Object[] authStepsFactories = beanFactory.getBeanNamesForType(AuthenticationStepsFactory.class);
        if (!ObjectUtils.isEmpty((Object[])authStepsFactories)) {
            AuthenticationStepsFactory factory = (AuthenticationStepsFactory)beanFactory.getBean(AuthenticationStepsFactory.class);
            return this.createAuthenticationStepsOperator(factory);
        }
        Object[] clientAuthentications = beanFactory.getBeanNamesForType(ClientAuthentication.class);
        if (!ObjectUtils.isEmpty((Object[])clientAuthentications)) {
            ClientAuthentication clientAuthentication = (ClientAuthentication)beanFactory.getBean(ClientAuthentication.class);
            if (clientAuthentication instanceof TokenAuthentication) {
                TokenAuthentication authentication = (TokenAuthentication)clientAuthentication;
                return () -> Mono.just((Object)authentication.login());
            }
            if (clientAuthentication instanceof AuthenticationStepsFactory) {
                return this.createAuthenticationStepsOperator((AuthenticationStepsFactory)clientAuthentication);
            }
            throw new IllegalStateException(String.format("Cannot construct VaultTokenSupplier from %s. ClientAuthentication must implement AuthenticationStepsFactory or be TokenAuthentication", clientAuthentication));
        }
        throw new IllegalStateException("Cannot construct VaultTokenSupplier. Please configure VaultTokenSupplier bean named vaultTokenSupplier.");
    }

    private VaultTokenSupplier createAuthenticationStepsOperator(AuthenticationStepsFactory factory) {
        WebClient webClient = ReactiveVaultClients.createWebClient((VaultEndpoint)this.vaultEndpoint, (ClientHttpConnector)this.clientHttpConnector);
        return new AuthenticationStepsOperator(factory.getAuthenticationSteps(), webClient);
    }
}

