/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.vault.config.GenericSecretBackendMetadata;
import org.springframework.cloud.vault.config.LeasingSecretBackendMetadata;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfiguration;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultPropertySourceLocatorSupport;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.env.LeaseAwareVaultPropertySource;
import org.springframework.vault.core.lease.SecretLeaseContainer;
import org.springframework.vault.core.lease.domain.RequestedSecret;
import org.springframework.vault.core.lease.event.LeaseErrorListener;

class LeasingVaultPropertySourceLocator
extends VaultPropertySourceLocatorSupport
implements PriorityOrdered {
    private static final Log log = LogFactory.getLog(LeasingVaultPropertySourceLocator.class);
    private final SecretLeaseContainer secretLeaseContainer;
    private final VaultProperties properties;

    LeasingVaultPropertySourceLocator(VaultProperties properties, PropertySourceLocatorConfiguration propertySourceLocatorConfiguration, SecretLeaseContainer secretLeaseContainer) {
        super("vault", propertySourceLocatorConfiguration);
        Assert.notNull((Object)secretLeaseContainer, (String)"SecretLeaseContainer must not be null");
        Assert.notNull((Object)properties, (String)"VaultProperties must not be null");
        this.secretLeaseContainer = secretLeaseContainer;
        this.properties = properties;
    }

    public int getOrder() {
        return this.properties.getConfig().getOrder();
    }

    @Override
    protected PropertySource<?> createVaultPropertySource(SecretBackendMetadata accessor) {
        RequestedSecret secret = this.getRequestedSecret(accessor);
        if (this.properties.isFailFast()) {
            return this.createVaultPropertySourceFailFast(secret, accessor);
        }
        return this.createVaultPropertySource(secret, accessor);
    }

    private RequestedSecret getRequestedSecret(SecretBackendMetadata accessor) {
        if (accessor instanceof LeasingSecretBackendMetadata) {
            LeasingSecretBackendMetadata leasingBackend = (LeasingSecretBackendMetadata)accessor;
            return RequestedSecret.from((RequestedSecret.Mode)leasingBackend.getLeaseMode(), (String)accessor.getPath());
        }
        if (accessor instanceof GenericSecretBackendMetadata) {
            return RequestedSecret.rotating((String)accessor.getPath());
        }
        return RequestedSecret.renewable((String)accessor.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySource<?> createVaultPropertySourceFailFast(RequestedSecret secret, SecretBackendMetadata accessor) {
        PropertySource<?> propertySource;
        AtomicReference errorRef = new AtomicReference();
        LeaseErrorListener errorListener = (leaseEvent, exception) -> {
            if (leaseEvent.getSource() == secret) {
                errorRef.compareAndSet(null, exception);
            }
        };
        this.secretLeaseContainer.addErrorListener(errorListener);
        try {
            propertySource = this.createVaultPropertySource(secret, accessor);
        }
        catch (Throwable throwable) {
            this.secretLeaseContainer.removeLeaseErrorListener(errorListener);
            Exception exception2 = (Exception)errorRef.get();
            if (exception2 != null) {
                if (exception2 instanceof VaultException) {
                    throw (VaultException)exception2;
                }
                throw new VaultException(String.format("Cannot initialize PropertySource for secret at %s", secret.getPath()), (Throwable)exception2);
            }
            throw throwable;
        }
        this.secretLeaseContainer.removeLeaseErrorListener(errorListener);
        Exception exception3 = (Exception)errorRef.get();
        if (exception3 != null) {
            if (exception3 instanceof VaultException) {
                throw (VaultException)exception3;
            }
            throw new VaultException(String.format("Cannot initialize PropertySource for secret at %s", secret.getPath()), (Throwable)exception3);
        }
        return propertySource;
    }

    private PropertySource<?> createVaultPropertySource(RequestedSecret secret, SecretBackendMetadata accessor) {
        return new LeaseAwareVaultPropertySource(accessor.getName(), this.secretLeaseContainer, secret, accessor.getPropertyTransformer());
    }
}

