/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.net.URI;
import java.time.Duration;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.vault.core.lease.LeaseEndpoints;

@ConfigurationProperties(value="spring.cloud.vault")
@Validated
public class VaultProperties
implements EnvironmentAware {
    private boolean enabled = true;
    private String host = "localhost";
    private int port = 8200;
    private String scheme = "https";
    private String uri;
    private String namespace;
    private Discovery discovery = new Discovery();
    private int connectionTimeout = 5000;
    private int readTimeout = 15000;
    private boolean failFast = false;
    private String token;
    private AppIdProperties appId = new AppIdProperties();
    private AppRoleProperties appRole = new AppRoleProperties();
    private AwsEc2Properties awsEc2 = new AwsEc2Properties();
    private AwsIamProperties awsIam = new AwsIamProperties();
    private AzureMsiProperties azureMsi = new AzureMsiProperties();
    private GcpGceProperties gcpGce = new GcpGceProperties();
    private GcpIamProperties gcpIam = new GcpIamProperties();
    private KubernetesProperties kubernetes = new KubernetesProperties();
    private PcfProperties pcf = new PcfProperties();
    private Ssl ssl = new Ssl();
    private Config config = new Config();
    private String applicationName = "application";
    private AuthenticationMethod authentication = AuthenticationMethod.TOKEN;

    public void setEnvironment(Environment environment) {
        String springAppName = environment.getProperty("spring.application.name");
        if (StringUtils.hasText((String)springAppName)) {
            this.applicationName = springAppName;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUri() {
        return this.uri;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public String getToken() {
        return this.token;
    }

    public AppIdProperties getAppId() {
        return this.appId;
    }

    public AppRoleProperties getAppRole() {
        return this.appRole;
    }

    public AwsEc2Properties getAwsEc2() {
        return this.awsEc2;
    }

    public AwsIamProperties getAwsIam() {
        return this.awsIam;
    }

    public AzureMsiProperties getAzureMsi() {
        return this.azureMsi;
    }

    public GcpGceProperties getGcpGce() {
        return this.gcpGce;
    }

    public GcpIamProperties getGcpIam() {
        return this.gcpIam;
    }

    public KubernetesProperties getKubernetes() {
        return this.kubernetes;
    }

    public PcfProperties getPcf() {
        return this.pcf;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public AuthenticationMethod getAuthentication() {
        return this.authentication;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setAppId(AppIdProperties appId) {
        this.appId = appId;
    }

    public void setAppRole(AppRoleProperties appRole) {
        this.appRole = appRole;
    }

    public void setAwsEc2(AwsEc2Properties awsEc2) {
        this.awsEc2 = awsEc2;
    }

    public void setAwsIam(AwsIamProperties awsIam) {
        this.awsIam = awsIam;
    }

    public void setAzureMsi(AzureMsiProperties azureMsi) {
        this.azureMsi = azureMsi;
    }

    public void setGcpGce(GcpGceProperties gcpGce) {
        this.gcpGce = gcpGce;
    }

    public void setGcpIam(GcpIamProperties gcpIam) {
        this.gcpIam = gcpIam;
    }

    public void setKubernetes(KubernetesProperties kubernetes) {
        this.kubernetes = kubernetes;
    }

    public void setPcf(PcfProperties pcf) {
        this.pcf = pcf;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setAuthentication(AuthenticationMethod authentication) {
        this.authentication = authentication;
    }

    public static class Lifecycle {
        private boolean enabled = true;
        private Duration minRenewal;
        private Duration expiryThreshold;
        private LeaseEndpoints leaseEndpoints;

        public boolean isEnabled() {
            return this.enabled;
        }

        public Duration getMinRenewal() {
            return this.minRenewal;
        }

        public Duration getExpiryThreshold() {
            return this.expiryThreshold;
        }

        public LeaseEndpoints getLeaseEndpoints() {
            return this.leaseEndpoints;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setMinRenewal(Duration minRenewal) {
            this.minRenewal = minRenewal;
        }

        public void setExpiryThreshold(Duration expiryThreshold) {
            this.expiryThreshold = expiryThreshold;
        }

        public void setLeaseEndpoints(LeaseEndpoints leaseEndpoints) {
            this.leaseEndpoints = leaseEndpoints;
        }
    }

    public static class Config {
        private int order = 0;
        private Lifecycle lifecycle = new Lifecycle();

        public int getOrder() {
            return this.order;
        }

        public Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void setLifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }
    }

    @Validated
    public static class Ssl {
        private Resource keyStore;
        private String keyStorePassword;
        private Resource trustStore;
        private String trustStorePassword;
        @NotEmpty
        private String certAuthPath = "cert";

        public Resource getKeyStore() {
            return this.keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public Resource getTrustStore() {
            return this.trustStore;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public String getCertAuthPath() {
            return this.certAuthPath;
        }

        public void setKeyStore(Resource keyStore) {
            this.keyStore = keyStore;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public void setTrustStore(Resource trustStore) {
            this.trustStore = trustStore;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public void setCertAuthPath(String certAuthPath) {
            this.certAuthPath = certAuthPath;
        }
    }

    public static class PcfProperties {
        @NotEmpty
        private String pcfPath = "pcf";
        private String role = "";
        private Resource instanceCertificate;
        private Resource instanceKey;

        public String getPcfPath() {
            return this.pcfPath;
        }

        public void setPcfPath(String pcfPath) {
            this.pcfPath = pcfPath;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public Resource getInstanceCertificate() {
            return this.instanceCertificate;
        }

        public void setInstanceCertificate(Resource instanceCertificate) {
            this.instanceCertificate = instanceCertificate;
        }

        public Resource getInstanceKey() {
            return this.instanceKey;
        }

        public void setInstanceKey(Resource instanceKey) {
            this.instanceKey = instanceKey;
        }
    }

    public static class KubernetesProperties {
        @NotEmpty
        private String kubernetesPath = "kubernetes";
        private String role = "";
        @NotEmpty
        private String serviceAccountTokenFile = "/var/run/secrets/kubernetes.io/serviceaccount/token";

        public String getKubernetesPath() {
            return this.kubernetesPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServiceAccountTokenFile() {
            return this.serviceAccountTokenFile;
        }

        public void setKubernetesPath(String kubernetesPath) {
            this.kubernetesPath = kubernetesPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServiceAccountTokenFile(String serviceAccountTokenFile) {
            this.serviceAccountTokenFile = serviceAccountTokenFile;
        }
    }

    public static class GcpCredentials {
        private Resource location;
        private String encodedKey;

        public Resource getLocation() {
            return this.location;
        }

        public String getEncodedKey() {
            return this.encodedKey;
        }

        public void setLocation(Resource location) {
            this.location = location;
        }

        public void setEncodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
        }
    }

    public static class GcpIamProperties {
        private final GcpCredentials credentials = new GcpCredentials();
        @NotEmpty
        private String gcpPath = "gcp";
        private String role = "";
        private String projectId = "";
        private String serviceAccountId = "";
        private Duration jwtValidity = Duration.ofMinutes(15L);

        public GcpCredentials getCredentials() {
            return this.credentials;
        }

        public String getGcpPath() {
            return this.gcpPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getServiceAccountId() {
            return this.serviceAccountId;
        }

        public Duration getJwtValidity() {
            return this.jwtValidity;
        }

        public void setGcpPath(String gcpPath) {
            this.gcpPath = gcpPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        public void setJwtValidity(Duration jwtValidity) {
            this.jwtValidity = jwtValidity;
        }
    }

    public static class GcpGceProperties {
        @NotEmpty
        private String gcpPath = "gcp";
        private String role = "";
        private String serviceAccount = "";

        public String getGcpPath() {
            return this.gcpPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServiceAccount() {
            return this.serviceAccount;
        }

        public void setGcpPath(String gcpPath) {
            this.gcpPath = gcpPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }
    }

    public static class AzureMsiProperties {
        @NotEmpty
        private String azurePath = "azure";
        private String role = "";

        public String getAzurePath() {
            return this.azurePath;
        }

        public String getRole() {
            return this.role;
        }

        public void setAzurePath(String azurePath) {
            this.azurePath = azurePath;
        }

        public void setRole(String role) {
            this.role = role;
        }
    }

    public static class AwsIamProperties {
        @NotEmpty
        private String awsPath = "aws";
        private String role = "";
        private String serverName;
        private URI endpointUri;

        public String getAwsPath() {
            return this.awsPath;
        }

        public String getRole() {
            return this.role;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setAwsPath(String awsPath) {
            this.awsPath = awsPath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public URI getEndpointUri() {
            return this.endpointUri;
        }

        public void setEndpointUri(URI endpointUri) {
            this.endpointUri = endpointUri;
        }
    }

    @Validated
    public static class AwsEc2Properties {
        @NotEmpty
        private String identityDocument = "http://169.254.169.254/latest/dynamic/instance-identity/pkcs7";
        @NotEmpty
        private String awsEc2Path = "aws-ec2";
        private String role = "";
        private String nonce;

        public String getIdentityDocument() {
            return this.identityDocument;
        }

        public String getAwsEc2Path() {
            return this.awsEc2Path;
        }

        public String getRole() {
            return this.role;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setIdentityDocument(String identityDocument) {
            this.identityDocument = identityDocument;
        }

        public void setAwsEc2Path(String awsEc2Path) {
            this.awsEc2Path = awsEc2Path;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }
    }

    @Validated
    public static class AppRoleProperties {
        private String appRolePath = "approle";
        private String role = "";
        private String roleId = null;
        private String secretId = null;

        public String getAppRolePath() {
            return this.appRolePath;
        }

        public String getRole() {
            return this.role;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public String getSecretId() {
            return this.secretId;
        }

        public void setAppRolePath(String appRolePath) {
            this.appRolePath = appRolePath;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public void setSecretId(String secretId) {
            this.secretId = secretId;
        }
    }

    @Validated
    public static class AppIdProperties {
        public static final String MAC_ADDRESS = "MAC_ADDRESS";
        public static final String IP_ADDRESS = "IP_ADDRESS";
        private String appIdPath = "app-id";
        private String networkInterface = null;
        @NotEmpty
        private String userId = "MAC_ADDRESS";

        public String getAppIdPath() {
            return this.appIdPath;
        }

        public String getNetworkInterface() {
            return this.networkInterface;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setAppIdPath(String appIdPath) {
            this.appIdPath = appIdPath;
        }

        public void setNetworkInterface(String networkInterface) {
            this.networkInterface = networkInterface;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }
    }

    public static class Discovery {
        public static final String DEFAULT_VAULT = "vault";
        private boolean enabled;
        private String serviceId = "vault";

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }
    }

    public static enum AuthenticationMethod {
        APPID,
        APPROLE,
        AWS_EC2,
        AWS_IAM,
        AZURE_MSI,
        CERT,
        CUBBYHOLE,
        GCP_GCE,
        GCP_IAM,
        KUBERNETES,
        PCF,
        TOKEN;

    }
}

