/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.vault.config.GenericSecretBackendMetadata;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfiguration;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.VaultGenericBackendProperties;
import org.springframework.cloud.vault.config.VaultKeyValueBackendPropertiesSupport;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public abstract class VaultPropertySourceLocatorSupport
implements PropertySourceLocator {
    private final String propertySourceName;
    private final PropertySourceLocatorConfiguration propertySourceLocatorConfiguration;

    public VaultPropertySourceLocatorSupport(String propertySourceName, VaultGenericBackendProperties genericBackendProperties, Collection<SecretBackendMetadata> backendAccessors) {
        this(propertySourceName, VaultPropertySourceLocatorSupport.createConfiguration(genericBackendProperties, backendAccessors));
    }

    public VaultPropertySourceLocatorSupport(String propertySourceName, PropertySourceLocatorConfiguration propertySourceLocatorConfiguration) {
        Assert.hasText((String)propertySourceName, (String)"PropertySource name must not be empty");
        Assert.notNull((Object)propertySourceLocatorConfiguration, (String)"PropertySourceLocatorConfiguration must not be null");
        this.propertySourceName = propertySourceName;
        this.propertySourceLocatorConfiguration = propertySourceLocatorConfiguration;
    }

    static PropertySourceLocatorConfiguration createConfiguration(VaultGenericBackendProperties genericBackendProperties, Collection<SecretBackendMetadata> backendAccessors) {
        Assert.notNull((Object)genericBackendProperties, (String)"VaultGenericBackendProperties must not be null");
        Assert.notNull(backendAccessors, (String)"BackendAccessors must not be null");
        GenericPropertySourceLocatorConfiguration generic = new GenericPropertySourceLocatorConfiguration(genericBackendProperties);
        WrappedPropertySourceLocatorConfiguration backends = new WrappedPropertySourceLocatorConfiguration(new ArrayList<SecretBackendMetadata>(backendAccessors));
        return new CompositePropertySourceConfiguration(generic, backends);
    }

    static PropertySourceLocatorConfiguration createConfiguration(VaultGenericBackendProperties genericBackendProperties) {
        Assert.notNull((Object)genericBackendProperties, (String)"VaultGenericBackendProperties must not be null");
        return new GenericPropertySourceLocatorConfiguration(genericBackendProperties);
    }

    public PropertySource<?> locate(Environment environment) {
        if (this.propertySourceLocatorConfiguration instanceof EnvironmentAware) {
            ((EnvironmentAware)this.propertySourceLocatorConfiguration).setEnvironment(environment);
        }
        CompositePropertySource propertySource = this.createCompositePropertySource(environment);
        this.initialize(propertySource);
        return propertySource;
    }

    protected void initialize(CompositePropertySource propertySource) {
    }

    protected CompositePropertySource createCompositePropertySource(Environment environment) {
        List<PropertySource<?>> propertySources = this.doCreatePropertySources(environment);
        return this.doCreateCompositePropertySource(this.propertySourceName, propertySources);
    }

    protected List<PropertySource<?>> doCreatePropertySources(Environment environment) {
        Collection<SecretBackendMetadata> secretBackends = this.propertySourceLocatorConfiguration.getSecretBackends();
        ArrayList<SecretBackendMetadata> sorted = new ArrayList<SecretBackendMetadata>(secretBackends);
        ArrayList propertySources = new ArrayList();
        AnnotationAwareOrderComparator.sort(sorted);
        propertySources.addAll(this.doCreateGenericPropertySources(environment));
        for (SecretBackendMetadata backendAccessor : sorted) {
            PropertySource<?> vaultPropertySource = this.createVaultPropertySource(backendAccessor);
            propertySources.add(vaultPropertySource);
        }
        return propertySources;
    }

    protected List<PropertySource<?>> doCreateGenericPropertySources(Environment environment) {
        return new ArrayList();
    }

    protected CompositePropertySource doCreateCompositePropertySource(String propertySourceName, List<PropertySource<?>> propertySources) {
        CompositePropertySource compositePropertySource = new CompositePropertySource(propertySourceName);
        for (PropertySource<?> propertySource : propertySources) {
            compositePropertySource.addPropertySource(propertySource);
        }
        return compositePropertySource;
    }

    protected abstract PropertySource<?> createVaultPropertySource(SecretBackendMetadata var1);

    private static class CompositePropertySourceConfiguration
    implements PropertySourceLocatorConfiguration,
    EnvironmentAware {
        private final List<PropertySourceLocatorConfiguration> configurations;

        CompositePropertySourceConfiguration(PropertySourceLocatorConfiguration ... configurations) {
            ArrayList<PropertySourceLocatorConfiguration> copy = new ArrayList<PropertySourceLocatorConfiguration>(Arrays.asList(configurations));
            AnnotationAwareOrderComparator.sortIfNecessary(copy);
            this.configurations = copy;
        }

        @Override
        public Collection<SecretBackendMetadata> getSecretBackends() {
            ArrayList<SecretBackendMetadata> result = new ArrayList<SecretBackendMetadata>();
            for (PropertySourceLocatorConfiguration configuration : this.configurations) {
                result.addAll(configuration.getSecretBackends());
            }
            return result;
        }

        public void setEnvironment(Environment environment) {
            for (PropertySourceLocatorConfiguration configuration : this.configurations) {
                if (!(configuration instanceof EnvironmentAware)) continue;
                ((EnvironmentAware)configuration).setEnvironment(environment);
            }
        }
    }

    private static class WrappedPropertySourceLocatorConfiguration
    implements PropertySourceLocatorConfiguration {
        private final List<SecretBackendMetadata> metadata;

        WrappedPropertySourceLocatorConfiguration(List<SecretBackendMetadata> metadata) {
            this.metadata = metadata;
        }

        @Override
        public Collection<SecretBackendMetadata> getSecretBackends() {
            return this.metadata;
        }
    }

    private static class GenericPropertySourceLocatorConfiguration
    implements EnvironmentAware,
    PropertySourceLocatorConfiguration {
        private final VaultKeyValueBackendPropertiesSupport genericBackendProperties;
        private Environment environment;

        GenericPropertySourceLocatorConfiguration(VaultKeyValueBackendPropertiesSupport genericBackendProperties) {
            this.genericBackendProperties = genericBackendProperties;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        @Override
        public Collection<SecretBackendMetadata> getSecretBackends() {
            if (this.genericBackendProperties.isEnabled()) {
                List<String> contexts = GenericSecretBackendMetadata.buildContexts(this.genericBackendProperties, Arrays.asList(this.environment.getActiveProfiles()));
                ArrayList<SecretBackendMetadata> result = new ArrayList<SecretBackendMetadata>(contexts.size());
                for (String context : contexts) {
                    result.add(GenericSecretBackendMetadata.create(this.genericBackendProperties.getBackend(), context));
                }
                return result;
            }
            return Collections.emptyList();
        }
    }
}

