/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.Secrets;
import org.springframework.cloud.vault.config.VaultConfigOperations;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.Assert;

class VaultPropertySource
extends EnumerablePropertySource<VaultConfigOperations> {
    private static final Log log = LogFactory.getLog(VaultPropertySource.class);
    private final boolean failFast;
    private final SecretBackendMetadata secretBackendMetadata;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private Secrets secrets;

    VaultPropertySource(VaultConfigOperations operations, boolean failFast, SecretBackendMetadata secretBackendMetadata) {
        super(secretBackendMetadata.getName(), (Object)operations);
        Assert.notNull((Object)operations, (String)"VaultConfigTemplate must not be null!");
        Assert.notNull((Object)secretBackendMetadata, (String)"SecretBackendMetadata must not be null!");
        this.failFast = failFast;
        this.secretBackendMetadata = secretBackendMetadata;
    }

    public void init() {
        try {
            this.secrets = ((VaultConfigOperations)this.source).read(this.secretBackendMetadata);
            if (this.secrets != null) {
                this.properties.putAll((Map)this.secrets.getData());
            }
        }
        catch (RuntimeException e) {
            String message = String.format("Unable to read properties from Vault using %s for %s ", this.getName(), this.secretBackendMetadata.getVariables());
            if (this.failFast) {
                throw e;
            }
            log.error((Object)message, (Throwable)e);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[0]);
    }
}

