/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigProperties;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySource;

public class ZookeeperPropertySources {
    private final ZookeeperConfigProperties properties;
    private final Log log;

    public ZookeeperPropertySources(ZookeeperConfigProperties properties, Log log) {
        this.properties = properties;
        this.log = log;
    }

    public List<String> getAutomaticContexts(List<String> profiles) {
        return this.getAutomaticContexts(profiles, true);
    }

    public List<String> getAutomaticContexts(List<String> profiles, boolean reverse) {
        String root = this.properties.getRoot();
        ArrayList<String> contexts = new ArrayList<String>();
        String defaultContext = root + "/" + this.properties.getDefaultContext();
        contexts.add(defaultContext);
        this.addProfiles(contexts, defaultContext, profiles);
        StringBuilder baseContext = new StringBuilder(root);
        if (!this.properties.getName().startsWith("/")) {
            baseContext.append("/");
        }
        baseContext.append(this.properties.getName());
        contexts.add(baseContext.toString());
        this.addProfiles(contexts, baseContext.toString(), profiles);
        if (reverse) {
            Collections.reverse(contexts);
        }
        return contexts;
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile);
        }
    }

    public ZookeeperPropertySource createPropertySource(String context, boolean optional, CuratorFramework curator) {
        try {
            return new ZookeeperPropertySource(context, curator);
        }
        catch (Exception e) {
            if (this.properties.isFailFast() || !optional) {
                throw new ZookeeperPropertySourceNotFoundException(e);
            }
            this.log.warn((Object)("Unable to load zookeeper config from " + context), (Throwable)e);
            return null;
        }
    }

    static class ZookeeperPropertySourceNotFoundException
    extends RuntimeException {
        ZookeeperPropertySourceNotFoundException(Exception source) {
            super(source);
        }
    }
}

