/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.Collections;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.config.ConfigWatcher;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnZookeeperEnabled
@ConditionalOnProperty(value={"spring.cloud.zookeeper.config.enabled"}, matchIfMissing=true)
public class ZookeeperConfigAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RefreshEndpoint.class})
    @ConditionalOnProperty(name={"spring.cloud.zookeeper.config.watcher.enabled"}, matchIfMissing=true)
    protected static class ZkRefreshConfiguration {
        protected ZkRefreshConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ZookeeperPropertySourceLocator.class})
        public ConfigWatcher propertySourceLocatorConfigWatcher(ZookeeperPropertySourceLocator locator, CuratorFramework curator) {
            return new ConfigWatcher(locator.getContexts(), curator);
        }

        @Bean
        @ConditionalOnMissingBean(value={ZookeeperPropertySourceLocator.class})
        public ConfigWatcher configDataConfigWatcher(CuratorFramework curator, Environment env) {
            List contexts = (List)env.getProperty("spring.cloud.zookeeper.config.property-source-contexts", List.class, Collections.emptyList());
            return new ConfigWatcher(contexts, curator);
        }
    }
}

