/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.hdfs.sink;

import javax.validation.constraints.Pattern;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="hdfs")
@Validated
public class HdfsSinkProperties {
    private String fsUri;
    @Value(value="/tmp/${spring.application.name:hdfs-sink}")
    private String directory;
    @Value(value="${spring.application.name:data}")
    private String fileName;
    private String fileExtension = "txt";
    private String codec = null;
    private boolean fileUuid = false;
    private boolean overwrite = false;
    private int rollover = 1000000000;
    private boolean enableSync = false;
    private long idleTimeout = 0L;
    private long closeTimeout = 0L;
    private long flushTimeout = 0L;
    private String inUsePrefix;
    private String inUseSuffix;
    private int fileOpenAttempts = 10;
    private String partitionPath;

    public String getFsUri() {
        return this.fsUri;
    }

    public void setFsUri(String fsUri) {
        this.fsUri = fsUri;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public boolean isFileUuid() {
        return this.fileUuid;
    }

    public void setFileUuid(boolean fileUuid) {
        this.fileUuid = fileUuid;
    }

    @Pattern(regexp="(?i)(GZIP|SNAPPY|BZIP2|LZO|SLZO)", message="codec must be one of GZIP, SNAPPY, BZIP2, LZO, or SLZO (case-insensitive)")
    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec.toUpperCase();
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public int getRollover() {
        return this.rollover;
    }

    public void setRollover(int rollover) {
        this.rollover = rollover;
    }

    public boolean isEnableSync() {
        return this.enableSync;
    }

    public void setEnableSync(boolean enableSync) {
        this.enableSync = enableSync;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(long closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public long getFlushTimeout() {
        return this.flushTimeout;
    }

    public void setFlushTimeout(long flushTimeout) {
        this.flushTimeout = flushTimeout;
    }

    public String getInUsePrefix() {
        return this.inUsePrefix;
    }

    public void setInUsePrefix(String inUsePrefix) {
        this.inUsePrefix = inUsePrefix;
    }

    public String getInUseSuffix() {
        return this.inUseSuffix;
    }

    public void setInUseSuffix(String inUseSuffix) {
        this.inUseSuffix = inUseSuffix;
    }

    public int getFileOpenAttempts() {
        return this.fileOpenAttempts;
    }

    public void setFileOpenAttempts(int fileOpenAttempts) {
        this.fileOpenAttempts = fileOpenAttempts;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String partitionPath) {
        this.partitionPath = partitionPath;
    }
}

