/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.app.twitterstream.source;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.app.twitter.TwitterCredentials;
import org.springframework.cloud.stream.app.twitterstream.source.TwitterStreamMessageProducer;
import org.springframework.cloud.stream.app.twitterstream.source.TwitterStreamProperties;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.core.MessageProducer;
import org.springframework.social.twitter.api.impl.TwitterTemplate;

@EnableBinding(value={Source.class})
@EnableConfigurationProperties(value={TwitterCredentials.class, TwitterStreamProperties.class})
public class TwitterstreamSourceConfiguration {
    @Autowired
    TwitterCredentials credentials;
    @Autowired
    TwitterStreamProperties twitterStreamProperties;
    @Autowired
    Source source;

    @Bean
    public MessageProducer twitterStream(TwitterTemplate twitterTemplate) {
        TwitterStreamMessageProducer messageProducer = new TwitterStreamMessageProducer(twitterTemplate, this.twitterStreamProperties);
        messageProducer.setOutputChannel(this.source.output());
        return messageProducer;
    }

    @Bean
    @ConditionalOnMissingBean
    public TwitterTemplate twitterTemplate() {
        return new TwitterTemplate(this.credentials.getConsumerKey(), this.credentials.getConsumerSecret(), this.credentials.getAccessToken(), this.credentials.getAccessTokenSecret());
    }
}

