/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.config.xml;

import com.datastax.driver.core.HostDistance;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cassandra.config.CassandraCqlClusterFactoryBean;
import org.springframework.cassandra.config.KeyspaceActionSpecificationFactoryBean;
import org.springframework.cassandra.config.KeyspaceAttributes;
import org.springframework.cassandra.config.MultiLevelSetFlattenerFactoryBean;
import org.springframework.cassandra.config.PoolingOptionsFactoryBean;
import org.springframework.cassandra.config.SocketOptionsFactoryBean;
import org.springframework.cassandra.config.xml.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CassandraCqlClusterParser
extends AbstractBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraCluster";
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CassandraCqlClusterFactoryBean.class);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        builder.getRawBeanDefinition().setDestroyMethodName("destroy");
        if (parserContext.isNested()) {
            builder.setScope(parserContext.getContainingBeanDefinition().getScope());
        }
        if (parserContext.isDefaultLazyInit()) {
            builder.setLazyInit(true);
        }
        this.doParse(element, parserContext, builder);
        return builder.getBeanDefinition();
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        ParsingUtils.addOptionalPropertyValue(builder, "contactPoints", element, "contact-points", null);
        ParsingUtils.addOptionalPropertyValue(builder, "port", element, "port", null);
        ParsingUtils.addOptionalPropertyValue(builder, "compressionType", element, "compression", null);
        ParsingUtils.addOptionalPropertyValue(builder, "username", element, "username", null);
        ParsingUtils.addOptionalPropertyValue(builder, "password", element, "password", null);
        ParsingUtils.addOptionalPropertyValue(builder, "metricsEnabled", element, "metrics-enabled", null);
        ParsingUtils.addOptionalPropertyValue(builder, "jmxReportingEnabled", element, "jmx-reporting-enabled", null);
        ParsingUtils.addOptionalPropertyValue(builder, "sslEnabled", element, "ssl-enabled", null);
        ParsingUtils.addOptionalPropertyReference(builder, "authProvider", element, "auth-info-provider-ref", null);
        ParsingUtils.addOptionalPropertyReference(builder, "loadBalancingPolicy", element, "load-balancing-policy-ref", null);
        ParsingUtils.addOptionalPropertyReference(builder, "reconnectionPolicy", element, "reconnection-policy-ref", null);
        ParsingUtils.addOptionalPropertyReference(builder, "retryPolicy", element, "retry-policy-ref", null);
        ParsingUtils.addOptionalPropertyReference(builder, "sslOptions", element, "ssl-options-ref", null);
        ParsingUtils.addOptionalPropertyReference(builder, "hostStateListener", element, "host-state-listener-ref", null);
        ParsingUtils.addOptionalPropertyReference(builder, "latencyTracker", element, "latency-tracker-ref", null);
        this.parseChildElements(element, context, builder);
    }

    protected void parseChildElements(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        ManagedSet keyspaceActionSpecificationBeanDefinitions = new ManagedSet();
        ArrayList<String> startupScripts = new ArrayList<String>();
        ArrayList<String> shutdownScripts = new ArrayList<String>();
        List elements = DomUtils.getChildElements((Element)element);
        BeanDefinition keyspaceActionSpecificationBeanDefinition = null;
        BeanDefinitionBuilder poolingOptionsBuilder = null;
        for (Element subElement : elements) {
            String name = subElement.getLocalName();
            if ("local-pooling-options".equals(name)) {
                poolingOptionsBuilder = this.parsePoolingOptions(subElement, poolingOptionsBuilder, HostDistance.LOCAL);
                continue;
            }
            if ("remote-pooling-options".equals(name)) {
                poolingOptionsBuilder = this.parsePoolingOptions(subElement, poolingOptionsBuilder, HostDistance.REMOTE);
                continue;
            }
            if ("socket-options".equals(name)) {
                builder.addPropertyValue("socketOptions", (Object)this.getSocketOptionsBeanDefinition(subElement, context));
                continue;
            }
            if ("keyspace".equals(name)) {
                keyspaceActionSpecificationBeanDefinition = this.getKeyspaceSpecificationBeanDefinition(subElement, context);
                keyspaceActionSpecificationBeanDefinitions.add((Object)keyspaceActionSpecificationBeanDefinition);
                continue;
            }
            if ("startup-cql".equals(name)) {
                startupScripts.add(this.parseScript(subElement));
                continue;
            }
            if (!"shutdown-cql".equals(name)) continue;
            shutdownScripts.add(this.parseScript(subElement));
        }
        if (poolingOptionsBuilder != null) {
            builder.addPropertyValue("poolingOptions", (Object)ParsingUtils.getSourceBeanDefinition(poolingOptionsBuilder, context, element));
        }
        builder.addPropertyValue("keyspaceSpecifications", this.getKeyspaceSetFlattenerBeanDefinition(element, context, (ManagedSet<BeanDefinition>)keyspaceActionSpecificationBeanDefinitions));
        builder.addPropertyValue("startupScripts", startupScripts);
        builder.addPropertyValue("shutdownScripts", startupScripts);
    }

    private Object getKeyspaceSetFlattenerBeanDefinition(Element element, ParserContext context, ManagedSet<BeanDefinition> keyspaceActionSpecificationBeanDefinitions) {
        BeanDefinitionBuilder flat = BeanDefinitionBuilder.genericBeanDefinition(MultiLevelSetFlattenerFactoryBean.class);
        flat.addPropertyValue("multiLevelSet", keyspaceActionSpecificationBeanDefinitions);
        return ParsingUtils.getSourceBeanDefinition(flat, context, element);
    }

    protected void parseReplication(Element element, BeanDefinitionBuilder builder) {
        ManagedList networkTopologyDataCenters = new ManagedList();
        ManagedList networkTopologyReplicationFactors = new ManagedList();
        if (element != null) {
            ParsingUtils.addOptionalPropertyValue(builder, "replicationStrategy", element, "class", KeyspaceAttributes.DEFAULT_REPLICATION_STRATEGY.name());
            ParsingUtils.addOptionalPropertyValue(builder, "replicationFactor", element, "replication-factor", "1");
            List dcElements = DomUtils.getChildElementsByTagName((Element)element, (String)"data-center");
            for (Element dataCenter : dcElements) {
                networkTopologyDataCenters.add((Object)dataCenter.getAttribute("name"));
                networkTopologyReplicationFactors.add((Object)dataCenter.getAttribute("replication-factor"));
            }
        }
        builder.addPropertyValue("networkTopologyDataCenters", (Object)networkTopologyDataCenters);
        builder.addPropertyValue("networkTopologyReplicationFactors", (Object)networkTopologyReplicationFactors);
    }

    protected String parseScript(Element element) {
        return element.getTextContent();
    }

    protected BeanDefinitionBuilder parsePoolingOptions(Element element, BeanDefinitionBuilder builder, HostDistance hostDistance) {
        if (builder == null) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(PoolingOptionsFactoryBean.class);
        }
        if (hostDistance.equals((Object)HostDistance.LOCAL)) {
            ParsingUtils.addOptionalPropertyValue(builder, "localMinSimultaneousRequests", element, "min-simultaneous-requests", null);
            ParsingUtils.addOptionalPropertyValue(builder, "localMaxSimultaneousRequests", element, "max-simultaneous-requests", null);
            ParsingUtils.addOptionalPropertyValue(builder, "localCoreConnections", element, "core-connections", null);
            ParsingUtils.addOptionalPropertyValue(builder, "localMaxConnections", element, "max-connections", null);
        }
        if (hostDistance.equals((Object)HostDistance.REMOTE)) {
            ParsingUtils.addOptionalPropertyValue(builder, "remoteMinSimultaneousRequests", element, "min-simultaneous-requests", null);
            ParsingUtils.addOptionalPropertyValue(builder, "remoteMaxSimultaneousRequests", element, "max-simultaneous-requests", null);
            ParsingUtils.addOptionalPropertyValue(builder, "remoteCoreConnections", element, "core-connections", null);
            ParsingUtils.addOptionalPropertyValue(builder, "remoteMaxConnections", element, "max-connections", null);
        }
        return builder;
    }

    protected BeanDefinition getSocketOptionsBeanDefinition(Element element, ParserContext context) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SocketOptionsFactoryBean.class);
        ParsingUtils.addOptionalPropertyValue(builder, "connectTimeoutMillis", element, "connect-timeout-mls", null);
        ParsingUtils.addOptionalPropertyValue(builder, "keepAlive", element, "keep-alive", null);
        ParsingUtils.addOptionalPropertyValue(builder, "readTimeoutMillis", element, "read-timeout-mls", null);
        ParsingUtils.addOptionalPropertyValue(builder, "reuseAddress", element, "reuse-address", null);
        ParsingUtils.addOptionalPropertyValue(builder, "soLinger", element, "so-linger", null);
        ParsingUtils.addOptionalPropertyValue(builder, "tcpNoDelay", element, "tcp-no-delay", null);
        ParsingUtils.addOptionalPropertyValue(builder, "receiveBufferSize", element, "receive-buffer-size", null);
        ParsingUtils.addOptionalPropertyValue(builder, "sendBufferSize", element, "send-buffer-size", null);
        return ParsingUtils.getSourceBeanDefinition(builder, context, element);
    }

    private BeanDefinition getKeyspaceSpecificationBeanDefinition(Element element, ParserContext context) {
        BeanDefinitionBuilder keyspaceBuilder = BeanDefinitionBuilder.genericBeanDefinition(KeyspaceActionSpecificationFactoryBean.class);
        ParsingUtils.addRequiredPropertyValue(keyspaceBuilder, "replicationStrategy", KeyspaceAttributes.DEFAULT_REPLICATION_STRATEGY.name());
        ParsingUtils.addRequiredPropertyValue(keyspaceBuilder, "replicationFactor", "1");
        ParsingUtils.addRequiredPropertyValue(keyspaceBuilder, "name", element, "name");
        ParsingUtils.addRequiredPropertyValue(keyspaceBuilder, "action", element, "action");
        ParsingUtils.addOptionalPropertyValue(keyspaceBuilder, "durableWrites", element, "durable-writes", "false");
        Element replicationElement = DomUtils.getChildElementByTagName((Element)element, (String)"replication");
        this.parseReplication(replicationElement, keyspaceBuilder);
        return ParsingUtils.getSourceBeanDefinition(keyspaceBuilder, context, element);
    }
}

