/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.support;

import com.datastax.driver.core.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cassandra.support.CassandraExceptionTranslator;
import org.springframework.util.Assert;

public class CassandraAccessor
implements InitializingBean {
    CassandraExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Session session;

    public void afterPropertiesSet() {
        Assert.state((this.session != null ? 1 : 0) != 0, (String)"Session must not be null");
    }

    protected void logDebug(String logMessage, Object ... array) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(logMessage, array);
        }
    }

    public void setExceptionTranslator(CassandraExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)exceptionTranslator, (String)"CassandraExceptionTranslator must not be null");
        this.exceptionTranslator = exceptionTranslator;
    }

    public CassandraExceptionTranslator getExceptionTranslator() {
        Assert.state((this.exceptionTranslator != null ? 1 : 0) != 0, (String)"CassandraExceptionTranslator was not properly initialized");
        return this.exceptionTranslator;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public Session getSession() {
        Assert.state((this.session != null ? 1 : 0) != 0, (String)"Session was not properly initialized");
        return this.session;
    }
}

