/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cassandra.core.keyspace;

import com.datastax.driver.core.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.keyspace.AddColumnSpecification;
import org.springframework.cassandra.core.keyspace.AlterColumnSpecification;
import org.springframework.cassandra.core.keyspace.ColumnChangeSpecification;
import org.springframework.cassandra.core.keyspace.RenameColumnSpecification;
import org.springframework.cassandra.core.keyspace.UserTypeNameSpecification;

public class AlterUserTypeSpecification
extends UserTypeNameSpecification<AlterUserTypeSpecification> {
    private final List<ColumnChangeSpecification> changes = new ArrayList<ColumnChangeSpecification>();

    public static AlterUserTypeSpecification alterType() {
        return new AlterUserTypeSpecification();
    }

    public static AlterUserTypeSpecification alterType(String typeName) {
        return AlterUserTypeSpecification.alterType(CqlIdentifier.cqlId(typeName));
    }

    public static AlterUserTypeSpecification alterType(CqlIdentifier typeName) {
        return (AlterUserTypeSpecification)AlterUserTypeSpecification.alterType().name(typeName);
    }

    public AlterUserTypeSpecification add(String field, DataType type) {
        return this.add(CqlIdentifier.cqlId(field), type);
    }

    public AlterUserTypeSpecification add(CqlIdentifier field, DataType type) {
        this.changes.add(new AddColumnSpecification(field, type));
        return this;
    }

    public AlterUserTypeSpecification alter(String field, DataType type) {
        return this.alter(CqlIdentifier.cqlId(field), type);
    }

    public AlterUserTypeSpecification alter(CqlIdentifier field, DataType type) {
        this.changes.add(new AlterColumnSpecification(field, type));
        return this;
    }

    public AlterUserTypeSpecification rename(String from, String to) {
        return this.rename(CqlIdentifier.cqlId(from), CqlIdentifier.cqlId(to));
    }

    public AlterUserTypeSpecification rename(CqlIdentifier from, CqlIdentifier to) {
        this.changes.add(new RenameColumnSpecification(from, to));
        return this;
    }

    public List<ColumnChangeSpecification> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }
}

