/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.support.exception.UnsupportedCassandraOperationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraPersistentPropertyComparator;
import org.springframework.data.cassandra.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.mapping.Table;
import org.springframework.data.cassandra.util.SpelUtils;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicCassandraPersistentEntity<T>
extends BasicPersistentEntity<T, CassandraPersistentProperty>
implements CassandraPersistentEntity<T>,
ApplicationContextAware {
    protected static final CassandraPersistentEntityMetadataVerifier DEFAULT_VERIFIER = new BasicCassandraPersistentEntityMetadataVerifier();
    protected CqlIdentifier tableName;
    protected CassandraMappingContext mappingContext;
    protected StandardEvaluationContext spelContext;
    protected CassandraPersistentEntityMetadataVerifier verifier = DEFAULT_VERIFIER;
    protected ApplicationContext context;
    protected Boolean forceQuote;

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation) {
        this(typeInformation, null);
    }

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation, CassandraMappingContext mappingContext) {
        this(typeInformation, mappingContext, DEFAULT_VERIFIER);
    }

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation, CassandraMappingContext mappingContext, CassandraPersistentEntityMetadataVerifier verifier) {
        super(typeInformation, (Comparator)CassandraPersistentPropertyComparator.IT);
        this.mappingContext = mappingContext;
        this.setVerifier(verifier);
    }

    protected CqlIdentifier determineTableName() {
        Table anno = this.getType().getAnnotation(Table.class);
        if (anno == null || !StringUtils.hasText((String)anno.value())) {
            return CqlIdentifier.cqlId((CharSequence)this.getType().getSimpleName(), (boolean)(anno == null ? false : anno.forceQuote()));
        }
        return CqlIdentifier.cqlId((CharSequence)(this.spelContext == null ? anno.value() : SpelUtils.evaluate(anno.value(), (EvaluationContext)this.spelContext)), (boolean)anno.forceQuote());
    }

    public void addAssociation(Association<CassandraPersistentProperty> association) {
        throw new UnsupportedCassandraOperationException("Cassandra does not support associations");
    }

    public void doWithAssociations(AssociationHandler<CassandraPersistentProperty> handler) {
        throw new UnsupportedCassandraOperationException("Cassandra does not support associations");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        Assert.notNull((Object)context);
        this.context = context;
        this.spelContext = new StandardEvaluationContext();
        this.spelContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.spelContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context));
        this.spelContext.setRootObject((Object)context);
    }

    @Override
    public CqlIdentifier getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        this.tableName = this.determineTableName();
        return this.tableName;
    }

    @Override
    public void setTableName(CqlIdentifier tableName) {
        Assert.notNull((Object)tableName);
        this.tableName = tableName;
    }

    @Override
    public void setForceQuote(boolean forceQuote) {
        if (this.forceQuote != null && this.forceQuote == forceQuote) {
            return;
        }
        this.forceQuote = forceQuote;
        this.setTableName(CqlIdentifier.cqlId((CharSequence)this.tableName.getUnquoted(), (boolean)forceQuote));
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return this.getType().isAnnotationPresent(PrimaryKeyClass.class);
    }

    @Override
    public List<CassandraPersistentProperty> getCompositePrimaryKeyProperties() {
        ArrayList<CassandraPersistentProperty> properties = new ArrayList<CassandraPersistentProperty>();
        if (!this.isCompositePrimaryKey()) {
            throw new IllegalStateException(String.format("[%s] does not represent a composite primary key class", this.getType().getName()));
        }
        this.addCompositePrimaryKeyProperties(this, properties);
        return properties;
    }

    protected void addCompositePrimaryKeyProperties(CassandraPersistentEntity<?> compositePrimaryKeyEntity, final List<CassandraPersistentProperty> properties) {
        compositePrimaryKeyEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty p) {
                if (p.isCompositePrimaryKey()) {
                    BasicCassandraPersistentEntity.this.addCompositePrimaryKeyProperties(p.getCompositePrimaryKeyEntity(), properties);
                } else {
                    properties.add(p);
                }
            }
        });
    }

    public void verify() throws MappingException {
        super.verify();
        if (this.verifier != null) {
            this.verifier.verify(this);
        }
    }

    public CassandraPersistentEntityMetadataVerifier getVerifier() {
        return this.verifier;
    }

    public void setVerifier(CassandraPersistentEntityMetadataVerifier verifier) {
        this.verifier = verifier;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.context;
    }
}

