/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;

public abstract class CassandraJsr310Converters {
    private static final boolean JAVA_8_IS_PRESENT = ClassUtils.isPresent((String)"java.time.LocalDateTime", (ClassLoader)Jsr310Converters.class.getClassLoader());

    private CassandraJsr310Converters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JAVA_8_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(CassandraLocalDateToLocalDateConverter.INSTANCE);
        converters.add(LocalDateToCassandraLocalDateConverter.INSTANCE);
        return converters;
    }

    @WritingConverter
    public static enum LocalDateToCassandraLocalDateConverter implements Converter<LocalDate, com.datastax.driver.core.LocalDate>
    {
        INSTANCE;


        public com.datastax.driver.core.LocalDate convert(LocalDate source) {
            return com.datastax.driver.core.LocalDate.fromYearMonthDay((int)source.getYear(), (int)source.getMonthValue(), (int)source.getDayOfMonth());
        }
    }

    @ReadingConverter
    public static enum CassandraLocalDateToLocalDateConverter implements Converter<com.datastax.driver.core.LocalDate, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(com.datastax.driver.core.LocalDate source) {
            return LocalDate.of(source.getYear(), source.getMonth(), source.getDay());
        }
    }
}

