/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.util.Comparator;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraPrimaryKeyColumnAnnotationComparator;
import org.springframework.data.cassandra.mapping.PrimaryKeyColumn;

public enum CassandraPersistentPropertyComparator implements Comparator<CassandraPersistentProperty>
{
    INSTANCE,
    IT;


    @Override
    public int compare(CassandraPersistentProperty left, CassandraPersistentProperty right) {
        boolean rightIsKey;
        if (left == null && right == null) {
            return 0;
        }
        if (left != null && right == null) {
            return 1;
        }
        if (left == null) {
            return -1;
        }
        if (left.equals(right)) {
            return 0;
        }
        boolean leftIsCompositePrimaryKey = left.isCompositePrimaryKey();
        boolean rightIsCompositePrimaryKey = right.isCompositePrimaryKey();
        if (leftIsCompositePrimaryKey && rightIsCompositePrimaryKey) {
            return 0;
        }
        boolean leftIsPrimaryKey = left.isPrimaryKeyColumn();
        boolean rightIsPrimaryKey = right.isPrimaryKeyColumn();
        if (leftIsPrimaryKey && rightIsPrimaryKey) {
            return CassandraPrimaryKeyColumnAnnotationComparator.INSTANCE.compare((PrimaryKeyColumn)left.findAnnotation(PrimaryKeyColumn.class), (PrimaryKeyColumn)right.findAnnotation(PrimaryKeyColumn.class));
        }
        boolean leftIsKey = leftIsCompositePrimaryKey || leftIsPrimaryKey;
        boolean bl = rightIsKey = rightIsCompositePrimaryKey || rightIsPrimaryKey;
        if (leftIsKey && !rightIsKey) {
            return -1;
        }
        if (!leftIsKey && rightIsKey) {
            return 1;
        }
        return left.getColumnName().compareTo(right.getColumnName());
    }
}

