/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.PrimaryKeyClassEntityMetadataVerifier;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.util.Assert;

public class CompositeCassandraPersistentEntityMetadataVerifier
implements CassandraPersistentEntityMetadataVerifier {
    private Collection<CassandraPersistentEntityMetadataVerifier> verifiers;

    public CompositeCassandraPersistentEntityMetadataVerifier() {
        this(Arrays.asList(new PrimaryKeyClassEntityMetadataVerifier(), new BasicCassandraPersistentEntityMetadataVerifier()));
    }

    private CompositeCassandraPersistentEntityMetadataVerifier(Collection<CassandraPersistentEntityMetadataVerifier> verifiers) {
        Assert.notNull(verifiers, (String)"Verifiers must not be null");
        this.verifiers = verifiers;
    }

    @Override
    public void verify(CassandraPersistentEntity<?> entity) throws MappingException {
        for (CassandraPersistentEntityMetadataVerifier verifier : this.verifiers) {
            verifier.verify(entity);
        }
    }
}

