/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.util.Assert;

public class VerifierMappingExceptions
extends MappingException {
    final Collection<MappingException> exceptions;
    private final String className;

    public VerifierMappingExceptions(CassandraPersistentEntity<?> entity, Collection<MappingException> exceptions) {
        super(String.format("Mapping Exceptions for %s", entity.getName()));
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        this.exceptions = Collections.unmodifiableCollection(new LinkedList<MappingException>(exceptions));
        this.className = entity.getType().getName();
    }

    public VerifierMappingExceptions(CassandraPersistentEntity<?> entity, String message) {
        super(message);
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        this.exceptions = new LinkedList<MappingException>();
        this.className = entity.getType().getName();
    }

    @Deprecated
    public void add(MappingException mappingException) {
        Assert.notNull((Object)mappingException, (String)"MappingException must not be null");
        this.exceptions.add(mappingException);
    }

    public Collection<MappingException> getMappingExceptions() {
        return Collections.unmodifiableCollection(this.exceptions);
    }

    public Collection<String> getMessages() {
        LinkedList<String> messages = new LinkedList<String>();
        for (MappingException e : this.exceptions) {
            messages.add(e.getMessage());
        }
        return messages;
    }

    public int getCount() {
        return this.exceptions.size();
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder(this.className).append(":\n");
        for (MappingException e : this.exceptions) {
            builder.append(" - ").append(e.getMessage()).append("\n");
        }
        return builder.toString();
    }
}

