/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import java.util.List;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.lang.Nullable;

public class ColumnReader {
    private final Row row;
    private final ColumnDefinitions columns;
    private final CodecRegistry codecRegistry;

    public ColumnReader(Row row) {
        this.row = row;
        this.columns = row.getColumnDefinitions();
        this.codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
    }

    @Nullable
    public Object get(CqlIdentifier name) {
        return this.get(name.toCql());
    }

    @Nullable
    public Object get(String name) {
        return this.get(this.getColumnIndex(name));
    }

    @Nullable
    public Object get(int index) {
        if (this.row.isNull(index)) {
            return null;
        }
        DataType type = this.columns.getType(index);
        if (type.isCollection()) {
            return this.getCollection(index, type);
        }
        if (DataType.Name.TUPLE.equals((Object)type.getName())) {
            return this.row.getTupleValue(index);
        }
        if (DataType.Name.UDT.equals((Object)type.getName())) {
            return this.row.getUDTValue(index);
        }
        return this.row.getObject(index);
    }

    @Nullable
    private Object getCollection(int i, DataType type) {
        List collectionTypes = type.getTypeArguments();
        if (collectionTypes.size() == 1) {
            DataType valueType = (DataType)collectionTypes.get(0);
            TypeCodec typeCodec = this.codecRegistry.codecFor(valueType);
            if (type.equals(DataType.list((DataType)valueType))) {
                return this.row.getList(i, typeCodec.getJavaType().getRawType());
            }
            if (type.equals(DataType.set((DataType)valueType))) {
                return this.row.getSet(i, typeCodec.getJavaType().getRawType());
            }
        }
        if (collectionTypes.size() == 2) {
            DataType keyType = (DataType)collectionTypes.get(0);
            TypeCodec keyTypeCodec = this.codecRegistry.codecFor(keyType);
            DataType valueType = (DataType)collectionTypes.get(1);
            TypeCodec valueTypeCodec = this.codecRegistry.codecFor(valueType);
            return this.row.getMap(i, keyTypeCodec.getJavaType().getRawType(), valueTypeCodec.getJavaType().getRawType());
        }
        throw new IllegalStateException("Unknown Collection type encountered. Valid collections are Set, List and Map.");
    }

    public Row getRow() {
        return this.row;
    }

    @Nullable
    public <T> T get(CqlIdentifier name, Class<T> requestedType) {
        return this.get(this.getColumnIndex(name.toCql()), requestedType);
    }

    @Nullable
    public <T> T get(String name, Class<T> requestedType) {
        return this.get(this.columns.getIndexOf(name), requestedType);
    }

    @Nullable
    public <T> T get(int i, Class<T> requestedType) {
        Object o = this.get(i);
        if (o == null) {
            return null;
        }
        return requestedType.cast(o);
    }

    private int getColumnIndex(String name) {
        int indexOf = this.columns.getIndexOf(name);
        if (indexOf == -1) {
            throw new IllegalArgumentException("Column does not exist in Cassandra table: " + name);
        }
        return indexOf;
    }
}

