/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import com.datastax.driver.core.PagingState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.data.cassandra.core.query.SerializationUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Query
implements Filter {
    private final boolean allowFiltering;
    private final Columns columns;
    private final List<CriteriaDefinition> criteriaDefinitions;
    private final Optional<Long> limit;
    private final Optional<PagingState> pagingState;
    private final Optional<QueryOptions> queryOptions;
    private final Sort sort;

    private Query(List<CriteriaDefinition> criteriaDefinitions, Columns columns, Sort sort, Optional<PagingState> pagingState, Optional<QueryOptions> queryOptions, Optional<Long> limit, boolean allowFiltering) {
        this.criteriaDefinitions = criteriaDefinitions;
        this.columns = columns;
        this.sort = sort;
        this.pagingState = pagingState;
        this.queryOptions = queryOptions;
        this.limit = limit;
        this.allowFiltering = allowFiltering;
    }

    public static Query empty() {
        return new Query(Collections.emptyList(), Columns.empty(), Sort.unsorted(), Optional.empty(), Optional.empty(), Optional.empty(), false);
    }

    public static Query query(CriteriaDefinition ... criteriaDefinitions) {
        Assert.notNull((Object)criteriaDefinitions, (String)"CriteriaDefinitions must not be null");
        return Query.query(Arrays.asList(criteriaDefinitions));
    }

    public static Query query(Iterable<? extends CriteriaDefinition> criteriaDefinitions) {
        Assert.notNull(criteriaDefinitions, (String)"CriteriaDefinitions must not be null");
        List<CriteriaDefinition> collect = StreamSupport.stream(criteriaDefinitions.spliterator(), false).collect(Collectors.toList());
        return new Query(collect, Columns.empty(), Sort.unsorted(), Optional.empty(), Optional.empty(), Optional.empty(), false);
    }

    public Query and(CriteriaDefinition criteriaDefinition) {
        Assert.notNull((Object)criteriaDefinition, (String)"Criteria must not be null");
        ArrayList<CriteriaDefinition> criteriaDefinitions = new ArrayList<CriteriaDefinition>(this.criteriaDefinitions.size() + 1);
        criteriaDefinitions.addAll(this.criteriaDefinitions);
        if (!criteriaDefinitions.contains(criteriaDefinition)) {
            criteriaDefinitions.add(criteriaDefinition);
        }
        return new Query(criteriaDefinitions, this.columns, this.sort, this.pagingState, this.queryOptions, this.limit, this.allowFiltering);
    }

    @Override
    public Iterable<CriteriaDefinition> getCriteriaDefinitions() {
        return Collections.unmodifiableCollection(this.criteriaDefinitions);
    }

    public Query columns(Columns columns) {
        Assert.notNull((Object)columns, (String)"Columns must not be null");
        return new Query(this.criteriaDefinitions, this.columns.and(columns), this.sort, this.pagingState, this.queryOptions, this.limit, this.allowFiltering);
    }

    public Columns getColumns() {
        return this.columns;
    }

    public Query sort(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        for (Sort.Order order : sort) {
            if (!order.isIgnoreCase()) continue;
            throw new IllegalArgumentException(String.format("Given sort contained an Order for %s with ignore case; Apache Cassandra does not support sorting ignoring case currently", order.getProperty()));
        }
        return new Query(this.criteriaDefinitions, this.columns, this.sort.and(sort), this.pagingState, this.queryOptions, this.limit, this.allowFiltering);
    }

    public Sort getSort() {
        return this.sort;
    }

    public Query pageRequest(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        CassandraPageRequest.validatePageable(pageable);
        PagingState pagingState = this.pagingState.orElse(null);
        if (pageable instanceof CassandraPageRequest) {
            pagingState = ((CassandraPageRequest)pageable).getPagingState();
        }
        QueryOptions queryOptions = this.queryOptions.map(QueryOptions::mutate).orElse(QueryOptions.builder()).fetchSize(pageable.getPageSize()).build();
        return new Query(this.criteriaDefinitions, this.columns, this.sort.and(pageable.getSort()), Optional.ofNullable(pagingState), Optional.of(queryOptions), this.limit, this.allowFiltering);
    }

    public Query pagingState(PagingState pagingState) {
        Assert.notNull((Object)pagingState, (String)"PagingState must not be null");
        return new Query(this.criteriaDefinitions, this.columns, this.sort, Optional.of(pagingState), this.queryOptions, this.limit, this.allowFiltering);
    }

    public Optional<PagingState> getPagingState() {
        return this.pagingState;
    }

    public Query queryOptions(QueryOptions queryOptions) {
        Assert.notNull((Object)queryOptions, (String)"QueryOptions must not be null");
        return new Query(this.criteriaDefinitions, this.columns, this.sort, this.pagingState, Optional.of(queryOptions), this.limit, this.allowFiltering);
    }

    public Optional<QueryOptions> getQueryOptions() {
        return this.queryOptions;
    }

    public Query limit(long limit) {
        return new Query(this.criteriaDefinitions, this.columns, this.sort, this.pagingState, this.queryOptions, Optional.of(limit), this.allowFiltering);
    }

    public long getLimit() {
        return this.limit.orElse(0L);
    }

    public Query withAllowFiltering() {
        return new Query(this.criteriaDefinitions, this.columns, this.sort, this.pagingState, this.queryOptions, this.limit, true);
    }

    public boolean isAllowFiltering() {
        return this.allowFiltering;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.querySettingsEquals((Query)obj);
    }

    protected boolean querySettingsEquals(Query that) {
        boolean criteriaEqual = this.criteriaDefinitions.equals(that.criteriaDefinitions);
        boolean columnsEqual = ObjectUtils.nullSafeEquals((Object)this.columns, (Object)that.columns);
        boolean sortEqual = ObjectUtils.nullSafeEquals((Object)this.sort, (Object)that.sort);
        boolean pagingStateEqual = ObjectUtils.nullSafeEquals(this.pagingState, that.pagingState);
        boolean queryOptionsEqual = ObjectUtils.nullSafeEquals(this.queryOptions, that.queryOptions);
        boolean limitEqual = this.limit == that.limit;
        boolean allowFilteringEqual = this.allowFiltering == that.allowFiltering;
        return criteriaEqual && columnsEqual && sortEqual && pagingStateEqual && queryOptionsEqual && limitEqual && allowFilteringEqual;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.criteriaDefinitions.hashCode();
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.columns);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.sort);
        result += 31 * ObjectUtils.nullSafeHashCode(this.pagingState);
        result += 31 * ObjectUtils.nullSafeHashCode(this.queryOptions);
        result += 31 * ObjectUtils.nullSafeHashCode(this.limit);
        return result += this.allowFiltering ? 0 : 1;
    }

    public String toString() {
        String query = StreamSupport.stream(this.spliterator(), false).map(SerializationUtils::serializeToCqlSafely).collect(Collectors.joining(" AND "));
        return String.format("Query: %s, Columns: %s, Sort: %s, Limit: %d", query, this.getColumns(), this.getSort(), this.getLimit());
    }
}

