/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.CassandraBatchOperations;
import org.springframework.data.cassandra.core.CassandraBatchTemplate;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.QueryUtils;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.CqlTemplate;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.SessionCallback;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CassandraTemplate
implements CassandraOperations {
    private final CassandraConverter converter;
    private final CqlOperations cqlOperations;
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final StatementFactory statementFactory;

    public CassandraTemplate(Session session) {
        this(session, (CassandraConverter)CassandraTemplate.newConverter());
    }

    public CassandraTemplate(Session session, CassandraConverter converter) {
        this(new DefaultSessionFactory(session), converter);
    }

    public CassandraTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        this(new CqlTemplate(sessionFactory), converter);
    }

    public CassandraTemplate(CqlOperations cqlOperations, CassandraConverter converter) {
        Assert.notNull((Object)cqlOperations, (String)"CqlOperations must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = cqlOperations;
        this.mappingContext = converter.getMappingContext();
        this.statementFactory = new StatementFactory(new QueryMapper(converter), new UpdateMapper(converter));
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    private static MappingCassandraConverter newConverter() {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.afterPropertiesSet();
        return converter;
    }

    @Override
    public CqlOperations getCqlOperations() {
        return this.cqlOperations;
    }

    protected MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    @Override
    public <T> List<T> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        return this.select((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> Stream<T> stream(String cql, Class<T> entityClass) throws DataAccessException {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.stream((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> T selectOne(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> List<T> select(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getCqlOperations().query(statement, (row, rowNum) -> this.getConverter().read(entityClass, row));
    }

    @Override
    public <T> Slice<T> slice(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ResultSet resultSet = this.getCqlOperations().queryForResultSet(statement);
        CassandraConverter converter = this.getConverter();
        return QueryUtils.readSlice(resultSet, (row, rowNum) -> converter.read(entityClass, row), 0, this.getEffectiveFetchSize(statement));
    }

    @Override
    public <T> Stream<T> stream(Statement statement, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return StreamSupport.stream(this.getCqlOperations().queryForResultSet(statement).spliterator(), false).map(row -> this.getConverter().read(entityClass, row));
    }

    @Override
    public <T> T selectOne(Statement statement, Class<T> entityClass) {
        return this.select(statement, entityClass).stream().findFirst().orElse(null);
    }

    @Override
    public <T> List<T> select(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)this.getStatementFactory().select(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> Slice<T> slice(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.slice((Statement)this.statementFactory.select(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> Stream<T> stream(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.stream((Statement)this.getStatementFactory().select(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> T selectOne(Query query, Class<T> entityClass) throws DataAccessException {
        List<T> result = this.select(query, entityClass);
        return result.isEmpty() ? null : (T)result.get(0);
    }

    @Override
    public boolean update(Query query, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getCqlOperations().execute((Statement)this.getStatementFactory().update(query, update, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)));
    }

    @Override
    public boolean delete(Query query, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getCqlOperations().execute((Statement)this.getStatementFactory().delete(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)));
    }

    @Override
    public long count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Select select = QueryBuilder.select().countAll().from(((CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)).getTableName().toCql());
        Long count = this.getCqlOperations().queryForObject((Statement)select, Long.class);
        return count != null ? count : 0L;
    }

    @Override
    public boolean exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass);
        Select select = QueryBuilder.select().from(entity.getTableName().toCql());
        this.getConverter().write(id, select.where(), entity);
        return this.getCqlOperations().queryForResultSet((Statement)select).iterator().hasNext();
    }

    @Override
    public <T> T selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass);
        Select select = QueryBuilder.select().all().from(entity.getTableName().toCql());
        this.getConverter().write(id, select.where(), entity);
        return this.selectOne((Statement)select, entityClass);
    }

    @Override
    public void insert(Object entity) {
        this.insert(entity, InsertOptions.empty());
    }

    @Override
    public WriteResult insert(Object entity, InsertOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        Insert insert = QueryUtils.createInsertQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.converter);
        return this.getCqlOperations().execute(new StatementCallback((Statement)insert));
    }

    @Override
    public void update(Object entity) {
        this.update(entity, UpdateOptions.empty());
    }

    @Override
    public WriteResult update(Object entity, UpdateOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        com.datastax.driver.core.querybuilder.Update update = QueryUtils.createUpdateQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.converter);
        return this.getCqlOperations().execute(new StatementCallback((Statement)update));
    }

    @Override
    public void delete(Object entity) {
        this.delete(entity, QueryOptions.empty());
    }

    @Override
    public WriteResult delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        Delete delete = QueryUtils.createDeleteQuery(this.getTableName(entity.getClass()).toCql(), entity, options, (EntityWriter<Object, Object>)this.converter);
        return this.getCqlOperations().execute(new StatementCallback((Statement)delete));
    }

    @Override
    public boolean deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass);
        Delete delete = QueryBuilder.delete().from(entity.getTableName().toCql());
        this.getConverter().write(id, delete.where(), entity);
        return this.getCqlOperations().execute((Statement)delete);
    }

    @Override
    public void truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Truncate truncate = QueryBuilder.truncate((String)((CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)).getTableName().toCql());
        this.getCqlOperations().execute((Statement)truncate);
    }

    @Override
    public CqlIdentifier getTableName(Class<?> entityClass) {
        return ((CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entityClass))).getTableName();
    }

    private int getEffectiveFetchSize(Statement statement) {
        CassandraAccessor accessor;
        if (statement.getFetchSize() > 0) {
            return statement.getFetchSize();
        }
        if (this.getCqlOperations() instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)this.getCqlOperations())).getFetchSize() != -1) {
            return accessor.getFetchSize();
        }
        return this.getCqlOperations().execute(session -> session.getCluster().getConfiguration().getQueryOptions().getFetchSize());
    }

    @Override
    public CassandraBatchOperations batchOps() {
        return new CassandraBatchTemplate(this);
    }

    static final class StatementCallback
    implements SessionCallback<WriteResult>,
    CqlProvider {
        @NonNull
        private final Statement statement;

        @Override
        public WriteResult doInSession(Session session) throws DriverException, DataAccessException {
            return WriteResult.of(session.execute(this.statement));
        }

        @Override
        public String getCql() {
            return this.statement.toString();
        }

        @ConstructorProperties(value={"statement"})
        public StatementCallback(@NonNull Statement statement) {
            if (statement == null) {
                throw new NullPointerException("statement");
            }
            this.statement = statement;
        }

        @NonNull
        public Statement getStatement() {
            return this.statement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementCallback)) {
                return false;
            }
            StatementCallback other = (StatementCallback)o;
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        public String toString() {
            return "CassandraTemplate.StatementCallback(statement=" + this.getStatement() + ")";
        }
    }
}

