/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.Session;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.config.AbstractClusterConfiguration;
import org.springframework.data.cassandra.config.CassandraCqlSessionFactoryBean;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.util.Assert;

@Configuration
public abstract class AbstractSessionConfiguration
extends AbstractClusterConfiguration {
    protected Session getRequiredSession() {
        CassandraCqlSessionFactoryBean factoryBean = this.session();
        Assert.state((factoryBean.getObject() != null ? 1 : 0) != 0, (String)"Session factory not initialized");
        return factoryBean.getObject();
    }

    @Bean
    public CassandraCqlSessionFactoryBean session() {
        CassandraCqlSessionFactoryBean bean = new CassandraCqlSessionFactoryBean();
        bean.setCluster(this.getRequiredCluster());
        bean.setKeyspaceName(this.getKeyspaceName());
        return bean;
    }

    @Bean
    public SessionFactory sessionFactory() {
        return new DefaultSessionFactory(this.getRequiredSession());
    }

    protected abstract String getKeyspaceName();
}

