/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.generator;

import java.util.Map;
import org.springframework.data.cassandra.core.cql.generator.KeyspaceOptionsCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceAttributes;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOption;
import org.springframework.data.cassandra.core.cql.keyspace.Option;

public class CreateKeyspaceCqlGenerator
extends KeyspaceOptionsCqlGenerator<CreateKeyspaceSpecification> {
    public CreateKeyspaceCqlGenerator(CreateKeyspaceSpecification specification) {
        super(specification);
    }

    public static String toCql(CreateKeyspaceSpecification specification) {
        return new CreateKeyspaceCqlGenerator(specification).toCql();
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        this.preambleCql(cql);
        this.optionsCql(cql);
        cql.append(";");
        return cql;
    }

    private void preambleCql(StringBuilder cql) {
        cql.append("CREATE KEYSPACE ").append(((CreateKeyspaceSpecification)this.spec()).getIfNotExists() ? "IF NOT EXISTS " : "").append(((CreateKeyspaceSpecification)this.spec()).getName());
    }

    private void optionsCql(StringBuilder cql) {
        Object durableWrites;
        cql.append(" ");
        Map<String, Object> options = ((CreateKeyspaceSpecification)this.spec()).getOptions();
        Object replicationOption = options.get(KeyspaceOption.REPLICATION.getName());
        if (replicationOption == null) {
            Map<Option, Object> simpleReplicationMap = KeyspaceAttributes.newSimpleReplication();
            ((CreateKeyspaceSpecification)this.spec()).with(KeyspaceOption.REPLICATION, simpleReplicationMap);
        }
        if ((durableWrites = options.get(KeyspaceOption.DURABLE_WRITES.getName())) == null) {
            ((CreateKeyspaceSpecification)this.spec()).with(KeyspaceOption.DURABLE_WRITES, Boolean.TRUE);
        }
        if (!options.isEmpty()) {
            boolean first = true;
            cql.append("WITH ");
            if (!options.isEmpty()) {
                for (String name : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        cql.append(" AND ");
                    }
                    cql.append(name);
                    Object value = options.get(name);
                    if (value == null) continue;
                    cql.append(" = ");
                    if (value instanceof Map) {
                        this.optionValueMap((Map)value, cql);
                        continue;
                    }
                    cql.append(value.toString());
                }
            }
        }
    }
}

