/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import java.util.List;
import java.util.stream.Stream;
import lombok.NonNull;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.ExecutableSelectOperation;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class ExecutableSelectOperationSupport
implements ExecutableSelectOperation {
    @NonNull
    private final CassandraTemplate template;

    @Override
    public <T> ExecutableSelectOperation.ExecutableSelect<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableSelectSupport<T>(this.template, domainType, domainType, Query.empty(), null);
    }

    public ExecutableSelectOperationSupport(@NonNull CassandraTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        this.template = template;
    }

    static class ExecutableSelectSupport<T>
    implements ExecutableSelectOperation.ExecutableSelect<T> {
        @NonNull
        private final CassandraTemplate template;
        @NonNull
        private final Class<?> domainType;
        @NonNull
        private final Class<T> returnType;
        @NonNull
        private final Query query;
        @Nullable
        private final CqlIdentifier tableName;

        @Override
        public ExecutableSelectOperation.SelectWithProjection<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ExecutableSelectSupport<T>(this.template, this.domainType, this.returnType, this.query, tableName);
        }

        @Override
        public <R> ExecutableSelectOperation.SelectWithQuery<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null");
            return new ExecutableSelectSupport<R>(this.template, this.domainType, returnType, this.query, this.tableName);
        }

        @Override
        public ExecutableSelectOperation.TerminatingSelect<T> matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ExecutableSelectSupport<T>(this.template, this.domainType, this.returnType, query2, this.tableName);
        }

        @Override
        public long count() {
            return this.template.doCount(this.query, this.domainType, this.getTableName());
        }

        @Override
        public boolean exists() {
            return this.template.doExists(this.query, this.domainType, this.getTableName());
        }

        @Override
        public T firstValue() {
            List<T> result = this.template.doSelect(this.query.limit(1L), this.domainType, this.getTableName(), this.returnType);
            return ObjectUtils.isEmpty(result) ? null : (T)result.iterator().next();
        }

        @Override
        public T oneValue() {
            List<T> result = this.template.doSelect(this.query.limit(2L), this.domainType, this.getTableName(), this.returnType);
            if (ObjectUtils.isEmpty(result)) {
                return null;
            }
            if (result.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(String.format("Query [%s] returned non unique result.", this.query), 1);
            }
            return result.iterator().next();
        }

        @Override
        public List<T> all() {
            return this.template.doSelect(this.query, this.domainType, this.getTableName(), this.returnType);
        }

        @Override
        public Stream<T> stream() {
            return this.template.doStream(this.query, this.domainType, this.getTableName(), this.returnType);
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }

        public ExecutableSelectSupport(@NonNull CassandraTemplate template, @NonNull Class<?> domainType, @NonNull Class<T> returnType, @NonNull Query query2, @Nullable CqlIdentifier tableName) {
            if (template == null) {
                throw new NullPointerException("template is marked non-null but is null");
            }
            if (domainType == null) {
                throw new NullPointerException("domainType is marked non-null but is null");
            }
            if (returnType == null) {
                throw new NullPointerException("returnType is marked non-null but is null");
            }
            if (query2 == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query2;
            this.tableName = tableName;
        }
    }
}

