/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.QueryUtils;
import org.springframework.data.cassandra.core.ReactiveCassandraBatchOperations;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.convert.EntityWriter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveCassandraBatchTemplate
implements ReactiveCassandraBatchOperations {
    private final ReactiveCassandraOperations operations;
    private final AtomicBoolean executed = new AtomicBoolean();
    private final Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
    private final List<Mono<Collection<? extends BuiltStatement>>> batchMonos = new CopyOnWriteArrayList<Mono<Collection<? extends BuiltStatement>>>();

    ReactiveCassandraBatchTemplate(ReactiveCassandraOperations operations) {
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        this.operations = operations;
    }

    @Override
    public Mono<WriteResult> execute() {
        return Mono.defer(() -> {
            if (this.executed.compareAndSet(false, true)) {
                return Flux.merge(this.batchMonos).flatMapIterable(Function.identity()).collectList().flatMap(statements -> {
                    statements.forEach(arg_0 -> ((Batch)this.batch).add(arg_0));
                    return this.operations.getReactiveCqlOperations().queryForResultSet((Statement)this.batch);
                }).flatMap(resultSet -> resultSet.rows().collectList().map(rows -> new WriteResult(resultSet.getAllExecutionInfo(), resultSet.wasApplied(), (List<Row>)rows)));
            }
            return Mono.error((Throwable)new IllegalStateException("This Cassandra Batch was already executed"));
        });
    }

    @Override
    public ReactiveCassandraBatchOperations withTimestamp(long timestamp) {
        this.assertNotExecuted();
        this.batch.using(QueryBuilder.timestamp((long)timestamp));
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.insert(Arrays.asList(entities));
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Iterable<?> entities) {
        return this.insert(entities, (WriteOptions)InsertOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Mono<? extends Iterable<?>> entities) {
        return this.insert(entities, (WriteOptions)InsertOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.batchMonos.add((Mono<Collection<? extends BuiltStatement>>)Mono.just(this.doInsert(entities, options)));
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Mono<? extends Iterable<?>> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.batchMonos.add((Mono<Collection<? extends BuiltStatement>>)entities.map(e -> this.doInsert((Iterable<?>)e, options)));
        return this;
    }

    private Collection<? extends BuiltStatement> doInsert(Iterable<?> entities, WriteOptions options) {
        ArrayList<Insert> insertQueries = new ArrayList<Insert>();
        CassandraConverter converter = this.operations.getConverter();
        CassandraMappingContext mappingContext = converter.getMappingContext();
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)mappingContext.getRequiredPersistentEntity(entity.getClass());
            insertQueries.add(QueryUtils.createInsertQuery(persistentEntity.getTableName().toCql(), entity, options, converter, persistentEntity));
        }
        return insertQueries;
    }

    @Override
    public ReactiveCassandraBatchOperations update(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.update(Arrays.asList(entities));
    }

    @Override
    public ReactiveCassandraBatchOperations update(Iterable<?> entities) {
        return this.update(entities, (WriteOptions)UpdateOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations update(Mono<? extends Iterable<?>> entities) {
        return this.update(entities, (WriteOptions)UpdateOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations update(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.batchMonos.add((Mono<Collection<? extends BuiltStatement>>)Mono.just(this.doUpdate(entities, options)));
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations update(Mono<? extends Iterable<?>> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.batchMonos.add((Mono<Collection<? extends BuiltStatement>>)entities.map(e -> this.doUpdate((Iterable<?>)e, options)));
        return this;
    }

    private Collection<? extends BuiltStatement> doUpdate(Iterable<?> entities, WriteOptions options) {
        ArrayList<Update> updateQueries = new ArrayList<Update>();
        CassandraConverter converter = this.operations.getConverter();
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            updateQueries.add(QueryUtils.createUpdateQuery(this.getTable(entity), entity, options, (EntityWriter<Object, Object>)converter));
        }
        return updateQueries;
    }

    @Override
    public ReactiveCassandraBatchOperations delete(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.delete(Arrays.asList(entities));
    }

    @Override
    public ReactiveCassandraBatchOperations delete(Iterable<?> entities) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        this.batchMonos.add((Mono<Collection<? extends BuiltStatement>>)Mono.just(this.doDelete(entities)));
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations delete(Mono<? extends Iterable<?>> entities) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        this.batchMonos.add((Mono<Collection<? extends BuiltStatement>>)entities.map(this::doDelete));
        return this;
    }

    private Collection<? extends BuiltStatement> doDelete(Iterable<?> entities) {
        ArrayList<Delete> deleteQueries = new ArrayList<Delete>();
        CassandraConverter converter = this.operations.getConverter();
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            deleteQueries.add(QueryUtils.createDeleteQuery(this.getTable(entity), entity, QueryOptions.empty(), (EntityWriter<Object, Object>)converter));
        }
        return deleteQueries;
    }

    private void assertNotExecuted() {
        Assert.state((!this.executed.get() ? 1 : 0) != 0, (String)"This Cassandra Batch was already executed");
    }

    private String getTable(Object entity) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        return ((BasicCassandraPersistentEntity)this.operations.getConverter().getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entity.getClass()))).getTableName().toCql();
    }
}

