/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.cql.PrimaryKeyType;
import org.springframework.data.cassandra.core.cql.keyspace.ColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.TableDescriptor;
import org.springframework.data.cassandra.core.cql.keyspace.TableOptionsSpecification;
import org.springframework.util.Assert;

public class TableSpecification<T>
extends TableOptionsSpecification<TableSpecification<T>>
implements TableDescriptor {
    private List<ColumnSpecification> columns = new ArrayList<ColumnSpecification>();
    private List<ColumnSpecification> partitionKeyColumns = new ArrayList<ColumnSpecification>();
    private List<ColumnSpecification> clusteredKeyColumns = new ArrayList<ColumnSpecification>();
    private List<ColumnSpecification> nonKeyColumns = new ArrayList<ColumnSpecification>();

    protected TableSpecification(CqlIdentifier name) {
        super(name);
    }

    public T column(String name, DataType type) {
        return this.column(CqlIdentifier.fromCql((String)name), type);
    }

    public T column(CqlIdentifier name, DataType type) {
        return this.column(name, type, Optional.empty(), Optional.empty());
    }

    public T partitionKeyColumn(String name, DataType type) {
        return this.partitionKeyColumn(CqlIdentifier.fromCql((String)name), type);
    }

    public T partitionKeyColumn(CqlIdentifier name, DataType type) {
        return this.column(name, type, Optional.of(PrimaryKeyType.PARTITIONED), Optional.empty());
    }

    public T clusteredKeyColumn(String name, DataType type) {
        return this.clusteredKeyColumn(CqlIdentifier.fromCql((String)name), type);
    }

    public T clusteredKeyColumn(String name, DataType type, Ordering ordering) {
        Assert.notNull((Object)((Object)ordering), (String)"Ordering must not be null");
        return this.column(CqlIdentifier.fromCql((String)name), type, Optional.of(PrimaryKeyType.CLUSTERED), Optional.of(ordering));
    }

    public T clusteredKeyColumn(CqlIdentifier name, DataType type) {
        return this.clusteredKeyColumn(name, type, Optional.empty());
    }

    public T clusteredKeyColumn(CqlIdentifier name, DataType type, Ordering ordering) {
        Assert.notNull((Object)((Object)ordering), (String)"Ordering must not be null");
        return this.column(name, type, Optional.of(PrimaryKeyType.CLUSTERED), Optional.of(ordering));
    }

    public T clusteredKeyColumn(CqlIdentifier name, DataType type, Optional<Ordering> ordering) {
        return this.column(name, type, Optional.of(PrimaryKeyType.CLUSTERED), ordering);
    }

    protected T column(String name, DataType type, PrimaryKeyType keyType) {
        return this.column(name, type, keyType, Optional.empty());
    }

    protected T column(String name, DataType type, PrimaryKeyType keyType, Ordering ordering) {
        Assert.notNull((Object)((Object)keyType), (String)"PrimaryKeyType must not be null");
        Assert.notNull((Object)((Object)ordering), (String)"Ordering must not be null");
        return this.column(CqlIdentifier.fromCql((String)name), type, Optional.of(keyType), Optional.of(ordering));
    }

    protected T column(String name, DataType type, PrimaryKeyType keyType, Optional<Ordering> ordering) {
        Assert.notNull((Object)((Object)keyType), (String)"PrimaryKeyType must not be null");
        Assert.notNull(ordering, (String)"Ordering must not be null");
        return this.column(CqlIdentifier.fromCql((String)name), type, Optional.of(keyType), ordering);
    }

    protected T column(CqlIdentifier name, DataType type, Optional<PrimaryKeyType> optionalKeyType, Optional<Ordering> optionalOrdering) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)type, (String)"DataType must not be null");
        Assert.notNull(optionalKeyType, (String)"PrimaryKeyType must not be null");
        Assert.notNull(optionalOrdering, (String)"Ordering must not be null");
        ColumnSpecification column = ColumnSpecification.name(name).type(type);
        optionalKeyType.ifPresent(keyType -> {
            column.keyType((PrimaryKeyType)((Object)keyType));
            optionalOrdering.filter(o -> keyType == PrimaryKeyType.CLUSTERED).ifPresent(column::ordering);
            if (keyType == PrimaryKeyType.PARTITIONED) {
                this.partitionKeyColumns.add(column);
            }
            if (keyType == PrimaryKeyType.CLUSTERED) {
                this.clusteredKeyColumns.add(column);
            }
        });
        this.columns.add(column);
        if (!optionalKeyType.isPresent()) {
            this.nonKeyColumns.add(column);
        }
        return (T)this;
    }

    @Override
    public List<ColumnSpecification> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public List<ColumnSpecification> getPartitionKeyColumns() {
        return Collections.unmodifiableList(this.partitionKeyColumns);
    }

    @Override
    public List<ColumnSpecification> getClusteredKeyColumns() {
        return Collections.unmodifiableList(this.clusteredKeyColumns);
    }

    @Override
    public List<ColumnSpecification> getPrimaryKeyColumns() {
        ArrayList<ColumnSpecification> primaryKeyColumns = new ArrayList<ColumnSpecification>();
        primaryKeyColumns.addAll(this.partitionKeyColumns);
        primaryKeyColumns.addAll(this.clusteredKeyColumns);
        return Collections.unmodifiableList(primaryKeyColumns);
    }

    @Override
    public List<ColumnSpecification> getNonKeyColumns() {
        return Collections.unmodifiableList(this.nonKeyColumns);
    }
}

