/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.cassandra.core.cql.PrimaryKeyType;
import org.springframework.data.cassandra.core.cql.generator.TableOptionsCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.ColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.TableSpecification;
import org.springframework.util.StringUtils;

public class CreateTableCqlGenerator
extends TableOptionsCqlGenerator<TableSpecification<CreateTableSpecification>> {
    public CreateTableCqlGenerator(CreateTableSpecification specification) {
        super(specification);
    }

    public static String toCql(CreateTableSpecification specification) {
        return new CreateTableCqlGenerator(specification).toCql();
    }

    @Override
    protected CreateTableSpecification spec() {
        return (CreateTableSpecification)super.spec();
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        this.preambleCql(cql);
        this.columnsAndOptionsCql(cql);
        cql.append(";");
        return cql;
    }

    private void preambleCql(StringBuilder cql) {
        cql.append("CREATE TABLE ").append(this.spec().getIfNotExists() ? "IF NOT EXISTS " : "").append(this.spec().getName().asCql(true));
    }

    private void columnsAndOptionsCql(StringBuilder cql) {
        cql.append(" (");
        ArrayList<ColumnSpecification> partitionKeys = new ArrayList<ColumnSpecification>();
        ArrayList<ColumnSpecification> clusterKeys = new ArrayList<ColumnSpecification>();
        for (ColumnSpecification col : this.spec().getColumns()) {
            col.toCql(cql).append(", ");
            if (col.getKeyType() == PrimaryKeyType.PARTITIONED) {
                partitionKeys.add(col);
                continue;
            }
            if (col.getKeyType() != PrimaryKeyType.CLUSTERED) continue;
            clusterKeys.add(col);
        }
        cql.append("PRIMARY KEY (");
        if (partitionKeys.size() > 1) {
            cql.append("(");
        }
        CreateTableCqlGenerator.appendColumnNames(cql, partitionKeys);
        if (partitionKeys.size() > 1) {
            cql.append(")");
        }
        if (!clusterKeys.isEmpty()) {
            cql.append(", ");
        }
        CreateTableCqlGenerator.appendColumnNames(cql, clusterKeys);
        cql.append(")");
        cql.append(")");
        StringBuilder ordering = CreateTableCqlGenerator.createOrderingClause(clusterKeys);
        Map<String, Object> options = this.spec().getOptions();
        if (!options.isEmpty() || StringUtils.hasText((CharSequence)ordering)) {
            boolean first = true;
            cql.append(" WITH ");
            if (StringUtils.hasText((CharSequence)ordering)) {
                cql.append((CharSequence)ordering);
                first = false;
            }
            if (!options.isEmpty()) {
                for (String name : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        cql.append(" AND ");
                    }
                    cql.append(name);
                    Object value = options.get(name);
                    if (value == null) continue;
                    cql.append(" = ");
                    if (value instanceof Map) {
                        this.optionValueMap((Map)value, cql);
                        continue;
                    }
                    cql.append(value.toString());
                }
            }
        }
    }

    private static StringBuilder createOrderingClause(List<ColumnSpecification> columns) {
        StringBuilder ordering = new StringBuilder();
        boolean first = true;
        for (ColumnSpecification col : columns) {
            if (col.getOrdering() == null) continue;
            if (!StringUtils.hasText((CharSequence)ordering)) {
                ordering.append("CLUSTERING ORDER BY (");
            }
            if (first) {
                first = false;
            } else {
                ordering.append(", ");
            }
            ordering.append(col.getName().asCql(true)).append(" ").append(col.getOrdering().cql());
        }
        if (StringUtils.hasText((CharSequence)ordering)) {
            ordering.append(")");
        }
        return ordering;
    }

    private static void appendColumnNames(StringBuilder str, List<ColumnSpecification> columns) {
        boolean first = true;
        for (ColumnSpecification col : columns) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(col.getName().asCql(true));
        }
    }
}

