/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.data.cassandra.core.mapping.IdInterfaceException;
import org.springframework.data.cassandra.core.mapping.IdInterfaceExceptions;
import org.springframework.data.mapping.MappingException;

class IdInterfaceValidator {
    IdInterfaceValidator() {
    }

    static void validate(Class<?> id) {
        ArrayList<MappingException> exceptions = new ArrayList<MappingException>();
        if (!id.isInterface()) {
            exceptions.add(new IdInterfaceException(id, null, "Id type must be an interface"));
        }
        block4: for (Method m : id.getDeclaredMethods()) {
            Class<?>[] args = m.getParameterTypes();
            String name = m.getName();
            Class<?> returnType = m.getReturnType();
            switch (args.length) {
                case 0: {
                    if (name.startsWith("get") && name.length() == 3) {
                        exceptions.add(new IdInterfaceException(id, m, "Getter method must have a property name following 'get' prefix"));
                    }
                    if (!Void.TYPE.isAssignableFrom(returnType) && !Void.class.isAssignableFrom(returnType)) continue block4;
                    exceptions.add(new IdInterfaceException(id, m, "Getter method must return a value"));
                    continue block4;
                }
                case 1: {
                    if (name.startsWith("set") && name.length() == 3) {
                        exceptions.add(new IdInterfaceException(id, m, "Setter method must have a property name following 'set' prefix"));
                    }
                    if (name.startsWith("with") && name.length() == 4) {
                        exceptions.add(new IdInterfaceException(id, m, "Setter method must have a property name following 'with' prefix"));
                    }
                    if (Void.TYPE.isAssignableFrom(returnType) || Void.class.equals(returnType) || id.equals(returnType)) continue block4;
                    exceptions.add(new IdInterfaceException(id, m, "Setter method not returning void may only return the same type as their id interface"));
                    continue block4;
                }
                default: {
                    exceptions.add(new IdInterfaceException(id, m, "Id interface methods may only take zero parameters for a getter or one parameter for a setter; found " + args.length));
                }
            }
        }
        if (!exceptions.isEmpty()) {
            throw new IdInterfaceExceptions(id, exceptions);
        }
    }
}

