/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import java.util.ArrayList;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.cassandra.config.CqlSessionFactoryBean;
import org.springframework.data.cassandra.config.KeyspaceActionSpecificationFactoryBean;
import org.springframework.data.cassandra.config.ParsingUtils;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceAttributes;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class CqlSessionParser
extends AbstractSingleBeanDefinitionParser {
    CqlSessionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return ExtendedCqlSessionFactoryBean.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraSession";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParsingUtils.addOptionalPropertyValue(builder, "keyspaceName", element, "keyspace-name");
        ParsingUtils.addOptionalPropertyValue(builder, "contactPointsAsString", element, "contact-points");
        ParsingUtils.addOptionalPropertyValue(builder, "localDatacenter", element, "local-datacenter");
        ParsingUtils.addOptionalPropertyValue(builder, "password", element, "password");
        ParsingUtils.addOptionalPropertyValue(builder, "port", element, "port");
        ParsingUtils.addOptionalPropertyValue(builder, "username", element, "username");
        if (element.hasAttribute("cassandra-converter-ref")) {
            ParsingUtils.addRequiredPropertyReference(builder, "converter", element, "cassandra-converter-ref");
        }
        ParsingUtils.addOptionalPropertyValue(builder, "schemaAction", element, "schema-action", SchemaAction.NONE.name());
        this.parseChildElements(element, parserContext, builder);
        builder.getRawBeanDefinition().setSource((Object)element);
    }

    protected void parseChildElements(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedSet keyspaceActionSpecificationBeanDefinitions = new ManagedSet();
        ArrayList<String> startupScripts = new ArrayList<String>();
        ArrayList<String> shutdownScripts = new ArrayList<String>();
        for (Element subElement : DomUtils.getChildElements((Element)element)) {
            String name = subElement.getLocalName();
            if ("keyspace".equals(name)) {
                keyspaceActionSpecificationBeanDefinitions.add((Object)this.newKeyspaceActionSpecificationBeanDefinition(subElement, parserContext));
                continue;
            }
            if ("keyspace-startup-cql".equals(name)) {
                startupScripts.add(this.parseScript(subElement));
                continue;
            }
            if ("keyspace-shutdown-cql".equals(name)) {
                shutdownScripts.add(this.parseScript(subElement));
                continue;
            }
            if ("startup-cql".equals(name)) {
                startupScripts.add(this.parseScript(subElement));
                continue;
            }
            if ("shutdown-cql".equals(name)) {
                shutdownScripts.add(this.parseScript(subElement));
                continue;
            }
            throw new IllegalStateException(String.format("encountered unhandled element [%s]", subElement.getLocalName()));
        }
        builder.addPropertyValue("keyspaceActions", (Object)keyspaceActionSpecificationBeanDefinitions);
        builder.addPropertyValue("startupScripts", startupScripts);
        builder.addPropertyValue("shutdownScripts", shutdownScripts);
    }

    private BeanDefinition newKeyspaceActionSpecificationBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(KeyspaceActionSpecificationFactoryBean.class);
        ParsingUtils.addRequiredPropertyValue(builder, "replicationStrategy", KeyspaceAttributes.DEFAULT_REPLICATION_STRATEGY.name());
        ParsingUtils.addRequiredPropertyValue(builder, "replicationFactor", String.valueOf(1L));
        ParsingUtils.addRequiredPropertyValue(builder, "name", element, "name");
        ParsingUtils.addOptionalPropertyValue(builder, "durableWrites", element, "durable-writes", "false");
        ParsingUtils.addRequiredPropertyValue(builder, "action", element, "action");
        return ParsingUtils.getSourceBeanDefinition(builder, parserContext, element);
    }

    String parseScript(Element element) {
        return element.getTextContent();
    }

    static class ExtendedCqlSessionFactoryBean
    extends CqlSessionFactoryBean {
        ExtendedCqlSessionFactoryBean() {
        }

        public void setContactPointsAsString(String contactPoints) {
            this.setContactPoints(contactPoints);
        }
    }
}

