/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.ExecutionProfileResolver;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DeleteOptions
extends WriteOptions {
    private static final DeleteOptions EMPTY = new DeleteOptionsBuilder().build();
    private final boolean ifExists;
    @Nullable
    private final Filter ifCondition;

    private DeleteOptions(@Nullable ConsistencyLevel consistencyLevel, ExecutionProfileResolver executionProfileResolver, @Nullable CqlIdentifier keyspace, @Nullable Integer pageSize, @Nullable ConsistencyLevel serialConsistencyLevel, Duration timeout, Duration ttl, @Nullable Long timestamp, @Nullable Boolean tracing, boolean ifExists, @Nullable Filter ifCondition) {
        super(consistencyLevel, executionProfileResolver, keyspace, pageSize, serialConsistencyLevel, timeout, ttl, timestamp, tracing);
        this.ifExists = ifExists;
        this.ifCondition = ifCondition;
    }

    public static DeleteOptionsBuilder builder() {
        return new DeleteOptionsBuilder();
    }

    public static DeleteOptions empty() {
        return EMPTY;
    }

    @Override
    public DeleteOptionsBuilder mutate() {
        return new DeleteOptionsBuilder(this);
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Nullable
    public Filter getIfCondition() {
        return this.ifCondition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeleteOptions that = (DeleteOptions)o;
        if (this.ifExists != that.ifExists) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.ifCondition, (Object)that.ifCondition);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ifExists ? 1 : 0);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.ifCondition);
        return result;
    }

    public static class DeleteOptionsBuilder
    extends WriteOptions.WriteOptionsBuilder {
        private boolean ifExists;
        @Nullable
        private Filter ifCondition;

        private DeleteOptionsBuilder() {
        }

        private DeleteOptionsBuilder(DeleteOptions deleteOptions) {
            super(deleteOptions);
            this.ifExists = deleteOptions.ifExists;
        }

        @Override
        public DeleteOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            super.consistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public DeleteOptionsBuilder executionProfile(String profileName) {
            super.executionProfile(profileName);
            return this;
        }

        @Override
        public DeleteOptionsBuilder executionProfile(ExecutionProfileResolver executionProfileResolver) {
            super.executionProfile(executionProfileResolver);
            return this;
        }

        @Override
        @Deprecated
        public DeleteOptionsBuilder fetchSize(int fetchSize) {
            super.fetchSize(fetchSize);
            return this;
        }

        @Override
        public DeleteOptionsBuilder keyspace(CqlIdentifier keyspace) {
            super.keyspace(keyspace);
            return this;
        }

        @Override
        public DeleteOptionsBuilder pageSize(int pageSize) {
            super.pageSize(pageSize);
            return this;
        }

        @Override
        @Deprecated
        public DeleteOptionsBuilder readTimeout(long readTimeout) {
            super.readTimeout(readTimeout);
            return this;
        }

        @Override
        @Deprecated
        public DeleteOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            super.readTimeout(readTimeout, timeUnit);
            return this;
        }

        @Override
        public DeleteOptionsBuilder serialConsistencyLevel(ConsistencyLevel consistencyLevel) {
            super.serialConsistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public DeleteOptionsBuilder timeout(Duration timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public DeleteOptionsBuilder ttl(Duration ttl) {
            super.ttl(ttl);
            return this;
        }

        @Override
        public DeleteOptionsBuilder tracing(boolean tracing) {
            super.tracing(tracing);
            return this;
        }

        @Override
        public DeleteOptionsBuilder withTracing() {
            super.withTracing();
            return this;
        }

        @Override
        public DeleteOptionsBuilder ttl(int ttl) {
            super.ttl(ttl);
            return this;
        }

        @Override
        public DeleteOptionsBuilder timestamp(long timestamp) {
            super.timestamp(timestamp);
            return this;
        }

        @Override
        public DeleteOptionsBuilder timestamp(Instant timestamp) {
            super.timestamp(timestamp);
            return this;
        }

        public DeleteOptionsBuilder withIfExists() {
            return this.ifExists(true);
        }

        public DeleteOptionsBuilder ifExists(boolean ifNotExists) {
            this.ifExists = ifNotExists;
            this.ifCondition = null;
            return this;
        }

        public DeleteOptionsBuilder ifCondition(CriteriaDefinition criteria) {
            Assert.notNull((Object)criteria, (String)"CriteriaDefinition must not be null");
            return this.ifCondition(Filter.from(criteria));
        }

        public DeleteOptionsBuilder ifCondition(Filter condition) {
            Assert.notNull((Object)condition, (String)"Filter condition must not be null");
            this.ifCondition = condition;
            this.ifExists = false;
            return this;
        }

        @Override
        public DeleteOptions build() {
            return new DeleteOptions(this.consistencyLevel, this.executionProfileResolver, this.keyspace, this.pageSize, this.serialConsistencyLevel, this.timeout, this.ttl, this.timestamp, this.tracing, this.ifExists, this.ifCondition);
        }
    }
}

