/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.cql.Row;
import java.net.InetAddress;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.cassandra.core.cql.converter.RowToListConverter;
import org.springframework.data.cassandra.core.cql.converter.RowToMapConverter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

abstract class CassandraConverters {
    private CassandraConverters() {
    }

    static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add((Object)RowToCassandraLocalDateConverter.INSTANCE);
        converters.add((Object)RowToBooleanConverter.INSTANCE);
        converters.add((Object)RowToInstantConverter.INSTANCE);
        converters.add((Object)RowToDateConverter.INSTANCE);
        converters.add((Object)RowToInetAddressConverter.INSTANCE);
        converters.add((Object)RowToListConverter.INSTANCE);
        converters.add((Object)RowToMapConverter.INSTANCE);
        converters.add((Object)RowToNumberConverterFactory.INSTANCE);
        converters.add((Object)RowToStringConverter.INSTANCE);
        converters.add((Object)RowToUuidConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum RowToCassandraLocalDateConverter implements Converter<Row, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(Row row) {
            return row.getLocalDate(0);
        }
    }

    @ReadingConverter
    public static enum RowToUuidConverter implements Converter<Row, UUID>
    {
        INSTANCE;


        public UUID convert(Row row) {
            return row.getUuid(0);
        }
    }

    @ReadingConverter
    public static enum RowToStringConverter implements Converter<Row, String>
    {
        INSTANCE;


        public String convert(Row row) {
            return row.getString(0);
        }
    }

    @ReadingConverter
    public static enum RowToNumberConverterFactory implements ConverterFactory<Row, Number>
    {
        INSTANCE;


        public <T extends Number> Converter<Row, T> getConverter(Class<T> targetType) {
            Assert.notNull(targetType, (String)"Target type must not be null");
            return new RowToNumber<T>(targetType);
        }

        private static final class RowToNumber<T extends Number>
        implements Converter<Row, T> {
            private final Class<T> targetType;

            RowToNumber(Class<T> targetType) {
                this.targetType = targetType;
            }

            public T convert(Row source) {
                Object object = source.getObject(0);
                return (T)(object != null ? (Number)NumberUtils.convertNumberToTargetClass((Number)((Number)object), this.targetType) : (Number)null);
            }
        }
    }

    @ReadingConverter
    public static enum RowToInetAddressConverter implements Converter<Row, InetAddress>
    {
        INSTANCE;


        public InetAddress convert(Row row) {
            return row.getInetAddress(0);
        }
    }

    @ReadingConverter
    public static enum RowToInstantConverter implements Converter<Row, Instant>
    {
        INSTANCE;


        public Instant convert(Row row) {
            return row.getInstant(0);
        }
    }

    @ReadingConverter
    public static enum RowToDateConverter implements Converter<Row, Date>
    {
        INSTANCE;


        public Date convert(Row row) {
            return Date.from(row.getInstant(0));
        }
    }

    @ReadingConverter
    public static enum RowToBooleanConverter implements Converter<Row, Boolean>
    {
        INSTANCE;


        public Boolean convert(Row row) {
            return row.getBoolean(0);
        }
    }
}

