/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.config.AbstractSessionConfiguration;
import org.springframework.data.cassandra.config.CassandraEntityClassScanner;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.config.SessionFactoryFactoryBean;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.cql.session.init.KeyspacePopulator;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.SimpleTupleTypeFactory;
import org.springframework.data.cassandra.core.mapping.SimpleUserTypeResolver;
import org.springframework.data.convert.CustomConversions;
import org.springframework.lang.Nullable;

@Configuration
public abstract class AbstractCassandraConfiguration
extends AbstractSessionConfiguration
implements BeanClassLoaderAware {
    @Nullable
    private ClassLoader beanClassLoader;

    @Bean
    public CassandraConverter cassandraConverter() {
        CqlSession cqlSession = this.getRequiredSession();
        SimpleUserTypeResolver userTypeResolver = new SimpleUserTypeResolver(cqlSession, CqlIdentifier.fromCql((String)this.getKeyspaceName()));
        MappingCassandraConverter converter = new MappingCassandraConverter(this.requireBeanOfType(CassandraMappingContext.class));
        converter.setCodecRegistry(cqlSession.getContext().getCodecRegistry());
        converter.setUserTypeResolver(userTypeResolver);
        converter.setCustomConversions(this.requireBeanOfType(CassandraCustomConversions.class));
        return converter;
    }

    @Bean
    public CassandraMappingContext cassandraMapping() throws ClassNotFoundException {
        CqlSession cqlSession = this.getRequiredSession();
        SimpleUserTypeResolver userTypeResolver = new SimpleUserTypeResolver(cqlSession, CqlIdentifier.fromCql((String)this.getKeyspaceName()));
        CassandraMappingContext mappingContext = new CassandraMappingContext(userTypeResolver, SimpleTupleTypeFactory.DEFAULT);
        CustomConversions customConversions = this.requireBeanOfType(CassandraCustomConversions.class);
        this.getBeanClassLoader().ifPresent(mappingContext::setBeanClassLoader);
        mappingContext.setCodecRegistry(cqlSession.getContext().getCodecRegistry());
        mappingContext.setCustomConversions(customConversions);
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        mappingContext.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        return mappingContext;
    }

    @Bean
    public SessionFactoryFactoryBean cassandraSessionFactory(CqlSession cqlSession) {
        SessionFactoryFactoryBean bean = new SessionFactoryFactoryBean();
        bean.setSession(cqlSession);
        bean.setConverter(this.requireBeanOfType(CassandraConverter.class));
        bean.setKeyspaceCleaner(this.keyspaceCleaner());
        bean.setKeyspacePopulator(this.keyspacePopulator());
        bean.setSchemaAction(this.getSchemaAction());
        return bean;
    }

    @Bean
    public CassandraAdminTemplate cassandraTemplate() {
        return new CassandraAdminTemplate(this.getRequiredSessionFactory(), this.requireBeanOfType(CassandraConverter.class));
    }

    @Bean
    public CassandraCustomConversions customConversions() {
        return new CassandraCustomConversions(Collections.emptyList());
    }

    public void setBeanClassLoader(@Nullable ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected Optional<ClassLoader> getBeanClassLoader() {
        return Optional.ofNullable(this.beanClassLoader);
    }

    public String[] getEntityBasePackages() {
        return new String[]{this.getClass().getPackage().getName()};
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        return CassandraEntityClassScanner.scan(this.getEntityBasePackages());
    }

    @Override
    protected SessionFactory getRequiredSessionFactory() {
        return this.requireBeanOfType(SessionFactory.class);
    }

    public SchemaAction getSchemaAction() {
        return SchemaAction.NONE;
    }

    @Nullable
    protected KeyspacePopulator keyspaceCleaner() {
        return null;
    }

    @Nullable
    protected KeyspacePopulator keyspacePopulator() {
        return null;
    }

    protected ByteArrayResource scriptOf(String content) {
        return new ByteArrayResource(content.getBytes());
    }
}

