/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public class WriteResult {
    private final boolean wasApplied;
    private final List<ExecutionInfo> executionInfo;
    private final List<Row> rows;

    WriteResult(List<ExecutionInfo> executionInfo, boolean wasApplied, List<Row> rows) {
        this.executionInfo = executionInfo;
        this.wasApplied = wasApplied;
        this.rows = rows;
    }

    WriteResult(ResultSet resultSet) {
        this.executionInfo = resultSet.getExecutionInfos();
        this.wasApplied = resultSet.wasApplied();
        int limit = resultSet.getAvailableWithoutFetching();
        ArrayList<Object> rows = new ArrayList<Object>(limit);
        for (int count = 0; count < limit; ++count) {
            rows.add(resultSet.one());
        }
        this.rows = Collections.unmodifiableList(rows);
    }

    public static WriteResult of(ResultSet resultSet) {
        Assert.notNull((Object)resultSet, (String)"ResultSet must not be null");
        return new WriteResult(resultSet);
    }

    public boolean wasApplied() {
        return this.wasApplied;
    }

    public List<ExecutionInfo> getExecutionInfo() {
        return this.executionInfo;
    }

    public List<Row> getRows() {
        return this.rows;
    }
}

