/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session.init;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.session.init.KeyspacePopulator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SessionFactoryInitializer
implements InitializingBean,
DisposableBean {
    @Nullable
    private SessionFactory sessionFactory;
    @Nullable
    private KeyspacePopulator keyspacePopulator;
    @Nullable
    private KeyspacePopulator keyspaceCleaner;
    private boolean enabled = true;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setKeyspacePopulator(KeyspacePopulator keyspacePopulator) {
        this.keyspacePopulator = keyspacePopulator;
    }

    public void setKeyspaceCleaner(KeyspacePopulator keyspaceCleaner) {
        this.keyspaceCleaner = keyspaceCleaner;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void afterPropertiesSet() {
        this.execute(this.keyspacePopulator);
    }

    public void destroy() {
        this.execute(this.keyspaceCleaner);
    }

    private void execute(@Nullable KeyspacePopulator populator) {
        Assert.state((this.sessionFactory != null ? 1 : 0) != 0, (String)"SessionFactory must be set");
        if (this.enabled && populator != null) {
            populator.populate(this.sessionFactory.getSession());
        }
    }
}

