/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.HostMapper;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.PreparedStatementCallback;
import org.springframework.data.cassandra.core.cql.PreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.data.cassandra.core.cql.ResultSetExtractor;
import org.springframework.data.cassandra.core.cql.RingMember;
import org.springframework.data.cassandra.core.cql.RingMemberHostMapper;
import org.springframework.data.cassandra.core.cql.RowCallbackHandler;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.RowMapperResultSetExtractor;
import org.springframework.data.cassandra.core.cql.SessionCallback;
import org.springframework.data.cassandra.core.cql.SimplePreparedStatementCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CqlTemplate
extends CassandraAccessor
implements CqlOperations {
    public CqlTemplate() {
    }

    public CqlTemplate(CqlSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.setSession(session);
    }

    public CqlTemplate(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null");
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public <T> T execute(SessionCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        try {
            return action.doInSession(this.getCurrentSession());
        }
        catch (DriverException e) {
            throw this.translateException("SessionCallback", CqlTemplate.toCql(action), (RuntimeException)((Object)e));
        }
    }

    @Override
    public boolean execute(String cql) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.queryForResultSet(cql).wasApplied();
    }

    @Override
    @Nullable
    public <T> T query(String cql, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Executing CQL statement [%s]", cql));
            }
            Statement<?> statement = this.applyStatementSettings((Statement<?>)this.newStatement(cql));
            ResultSet results = this.getCurrentSession().execute(statement);
            return resultSetExtractor.extractData(results);
        }
        catch (DriverException e) {
            throw this.translateException("Query", cql, (RuntimeException)((Object)e));
        }
    }

    @Override
    public void query(String cql, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(cql, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(cql, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public List<Map<String, Object>> queryForList(String cql) throws DataAccessException {
        return (List)((Object)this.query(cql, this.newResultSetExtractor(this.newColumnMapRowMapper())));
    }

    @Override
    public <T> List<T> queryForList(String cql, Class<T> elementType) throws DataAccessException {
        return (List)this.query(cql, this.newResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public Map<String, Object> queryForMap(String cql) throws DataAccessException {
        return this.queryForObject(cql, this.newColumnMapRowMapper());
    }

    @Override
    public <T> T queryForObject(String cql, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(cql, this.newSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.query(cql, this.newResultSetExtractor(rowMapper))));
    }

    @Override
    public ResultSet queryForResultSet(String cql) throws DataAccessException {
        return this.query(cql, (ResultSet rs) -> rs);
    }

    @Override
    public Iterable<Row> queryForRows(String cql) throws DataAccessException {
        return () -> this.queryForResultSet(cql).iterator();
    }

    @Override
    public boolean execute(Statement<?> statement) throws DataAccessException {
        Assert.notNull(statement, (String)"CQL Statement must not be null");
        return this.queryForResultSet(statement).wasApplied();
    }

    @Override
    public <T> T query(Statement<?> statement, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.notNull(statement, (String)"CQL Statement must not be null");
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Executing statement [%s]", CqlTemplate.toCql(statement)));
            }
            return resultSetExtractor.extractData(this.getCurrentSession().execute(this.applyStatementSettings(statement)));
        }
        catch (DriverException e) {
            throw this.translateException("Query", CqlTemplate.toCql(statement), (RuntimeException)((Object)e));
        }
    }

    @Override
    public void query(Statement<?> statement, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(statement, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(Statement<?> statement, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(statement, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public <T> Stream<T> queryForStream(Statement<?> statement, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(statement, this.newStreamExtractor(rowMapper));
    }

    @Override
    public List<Map<String, Object>> queryForList(Statement<?> statement) throws DataAccessException {
        return (List)((Object)this.query(statement, this.newResultSetExtractor(this.newColumnMapRowMapper())));
    }

    @Override
    public <T> List<T> queryForList(Statement<?> statement, Class<T> elementType) throws DataAccessException {
        return (List)this.query(statement, this.newResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public Map<String, Object> queryForMap(Statement<?> statement) throws DataAccessException {
        return this.queryForObject(statement, this.newColumnMapRowMapper());
    }

    @Override
    public <T> T queryForObject(Statement<?> statement, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(statement, this.newSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(Statement<?> statement, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.query(statement, this.newResultSetExtractor(rowMapper))));
    }

    @Override
    public ResultSet queryForResultSet(Statement<?> statement) throws DataAccessException {
        return this.query(statement, (ResultSet rs) -> rs);
    }

    @Override
    public Iterable<Row> queryForRows(Statement<?> statement) throws DataAccessException {
        return () -> this.queryForResultSet(statement).iterator();
    }

    @Override
    public boolean execute(String cql, Object ... args) throws DataAccessException {
        return this.execute(cql, this.newPreparedStatementBinder(args));
    }

    @Override
    public boolean execute(String cql, @Nullable PreparedStatementBinder psb) throws DataAccessException {
        return this.query(this.newPreparedStatementCreator(cql), psb, ResultSet::wasApplied);
    }

    @Override
    @Nullable
    public <T> T execute(String cql, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(this.newPreparedStatementCreator(cql), action);
    }

    @Override
    public boolean execute(PreparedStatementCreator preparedStatementCreator) throws DataAccessException {
        return this.query(preparedStatementCreator, ResultSet::wasApplied);
    }

    @Override
    @Nullable
    public <T> T execute(PreparedStatementCreator preparedStatementCreator, PreparedStatementCallback<T> action) throws DataAccessException {
        Assert.notNull((Object)preparedStatementCreator, (String)"PreparedStatementCreator must not be null");
        Assert.notNull(action, (String)"PreparedStatementCallback object must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Preparing statement [%s] using %s", CqlTemplate.toCql(preparedStatementCreator), preparedStatementCreator));
            }
            CqlSession session = this.getCurrentSession();
            return action.doInPreparedStatement(session, preparedStatementCreator.createPreparedStatement(session));
        }
        catch (DriverException e) {
            throw this.translateException("PreparedStatementCallback", CqlTemplate.toCql(preparedStatementCreator), (RuntimeException)((Object)e));
        }
    }

    @Override
    public <T> T query(PreparedStatementCreator preparedStatementCreator, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        return this.query(preparedStatementCreator, null, resultSetExtractor);
    }

    @Override
    public void query(PreparedStatementCreator preparedStatementCreator, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(preparedStatementCreator, null, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator preparedStatementCreator, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(preparedStatementCreator, null, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public <T> Stream<T> queryForStream(PreparedStatementCreator preparedStatementCreator, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(preparedStatementCreator, null, this.newStreamExtractor(rowMapper));
    }

    @Override
    @Nullable
    public <T> T query(PreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.notNull((Object)preparedStatementCreator, (String)"PreparedStatementCreator must not be null");
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor object must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Preparing statement [%s] using %s", CqlTemplate.toCql(preparedStatementCreator), preparedStatementCreator));
            }
            CqlSession session = this.getCurrentSession();
            PreparedStatement preparedStatement = preparedStatementCreator.createPreparedStatement(session);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Executing prepared statement [%s]", QueryExtractorDelegate.getCql(preparedStatement)));
            }
            Statement<?> boundStatement = this.applyStatementSettings((Statement<?>)(psb != null ? psb.bindValues(preparedStatement) : preparedStatement.bind(new Object[0])));
            ResultSet results = session.execute(boundStatement);
            return resultSetExtractor.extractData(results);
        }
        catch (DriverException e) {
            throw this.translateException("Query", CqlTemplate.toCql(preparedStatementCreator), (RuntimeException)((Object)e));
        }
    }

    @Override
    public void query(PreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(preparedStatementCreator, psb, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(preparedStatementCreator, psb, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public <T> Stream<T> queryForStream(PreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(preparedStatementCreator, psb, this.newStreamExtractor(rowMapper));
    }

    @Override
    public <T> T query(String cql, ResultSetExtractor<T> resultSetExtractor, Object ... args) throws DataAccessException {
        return this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), resultSetExtractor);
    }

    @Override
    public void query(String cql, RowCallbackHandler rowCallbackHandler, Object ... args) throws DataAccessException {
        this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return (List)this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(rowMapper));
    }

    @Override
    public <T> Stream<T> queryForStream(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newStreamExtractor(rowMapper));
    }

    @Override
    public <T> T query(String cql, @Nullable PreparedStatementBinder psb, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        return this.query(this.newPreparedStatementCreator(cql), psb, resultSetExtractor);
    }

    @Override
    public void query(String cql, @Nullable PreparedStatementBinder psb, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(this.newPreparedStatementCreator(cql), psb, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(String cql, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(this.newPreparedStatementCreator(cql), psb, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public List<Map<String, Object>> queryForList(String cql, Object ... args) throws DataAccessException {
        return (List)((Object)this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(this.newColumnMapRowMapper())));
    }

    @Override
    public <T> List<T> queryForList(String cql, Class<T> elementType, Object ... args) throws DataAccessException {
        return (List)this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public Map<String, Object> queryForMap(String cql, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.newColumnMapRowMapper(), args);
    }

    @Override
    public <T> T queryForObject(String cql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.newSingleColumnRowMapper(requiredType), args);
    }

    @Override
    public <T> T queryForObject(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(rowMapper, 1))));
    }

    @Override
    public ResultSet queryForResultSet(String cql, Object ... args) throws DataAccessException {
        return this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), (ResultSet rs) -> rs);
    }

    @Override
    public Iterable<Row> queryForRows(String cql, Object ... args) throws DataAccessException {
        return () -> this.queryForResultSet(cql, args).iterator();
    }

    @Override
    public List<RingMember> describeRing() throws DataAccessException {
        return (List)this.describeRing(RingMemberHostMapper.INSTANCE);
    }

    @Override
    public <T> Collection<T> describeRing(HostMapper<T> hostMapper) throws DataAccessException {
        Assert.notNull(hostMapper, (String)"HostMapper must not be null");
        return hostMapper.mapHosts(this.getHosts());
    }

    private Collection<Node> getHosts() {
        return this.getCurrentSession().getMetadata().getNodes().values();
    }

    protected DataAccessException translateException(String task, @Nullable String cql, RuntimeException RuntimeException2) {
        return this.translate(task, cql, RuntimeException2);
    }

    protected PreparedStatementCreator newPreparedStatementCreator(String cql) {
        return new SimplePreparedStatementCreator((SimpleStatement)this.applyStatementSettings((Statement<?>)SimpleStatement.newInstance((String)cql)));
    }

    protected RowCallbackHandlerResultSetExtractor newResultSetExtractor(RowCallbackHandler rowCallbackHandler) {
        return new RowCallbackHandlerResultSetExtractor(rowCallbackHandler);
    }

    protected <T> RowMapperResultSetExtractor<T> newResultSetExtractor(RowMapper<T> rowMapper) {
        return new RowMapperResultSetExtractor<T>(rowMapper);
    }

    protected <T> RowMapperResultSetExtractor<T> newResultSetExtractor(RowMapper<T> rowMapper, int rowsExpected) {
        return new RowMapperResultSetExtractor<T>(rowMapper, rowsExpected);
    }

    protected <T> ResultSetExtractor<Stream<T>> newStreamExtractor(RowMapper<T> rowMapper) {
        return resultSet -> new ResultSetSpliterator(resultSet, rowMapper).stream();
    }

    private CqlSession getCurrentSession() {
        SessionFactory sessionFactory = this.getSessionFactory();
        Assert.state((sessionFactory != null ? 1 : 0) != 0, (String)"SessionFactory is null");
        return sessionFactory.getSession();
    }

    protected static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor<Object> {
        private final RowCallbackHandler rowCallbackHandler;

        protected RowCallbackHandlerResultSetExtractor(RowCallbackHandler rowCallbackHandler) {
            this.rowCallbackHandler = rowCallbackHandler;
        }

        @Override
        @Nullable
        public Object extractData(ResultSet resultSet) {
            resultSet.forEach(this.rowCallbackHandler::processRow);
            return null;
        }
    }

    private static class ResultSetSpliterator<T>
    implements Spliterator<T> {
        private final Spliterator<Row> delegate;
        private final RowMapper<T> rowMapper;
        private final AtomicInteger counter;

        public ResultSetSpliterator(ResultSet rs, RowMapper<T> rowMapper) {
            this.delegate = rs.spliterator();
            this.rowMapper = rowMapper;
            this.counter = new AtomicInteger();
        }

        private ResultSetSpliterator(Spliterator<Row> delegate, RowMapper<T> rowMapper, AtomicInteger counter) {
            this.delegate = delegate;
            this.rowMapper = rowMapper;
            this.counter = counter;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.delegate.tryAdvance(row -> action.accept((T)this.rowMapper.mapRow((Row)row, this.counter.incrementAndGet())));
        }

        @Override
        @Nullable
        public Spliterator<T> trySplit() {
            return new ResultSetSpliterator<T>(this.delegate.trySplit(), this.rowMapper, this.counter);
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 16;
        }

        public Stream<T> stream() {
            return StreamSupport.stream(this, false);
        }
    }
}

